/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.monitor.instance;

import com.netflix.config.ConfigurationManager;
import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.turbine.discovery.Instance;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;

public interface InstanceUrlClosure {
    public static final InstanceUrlClosure ClusterConfigBasedUrlClosure = new InstanceUrlClosure(){
        private final DynamicStringProperty defaultUrlClosureConfig = DynamicPropertyFactory.getInstance().getStringProperty("turbine.instanceUrlSuffix", null);

        @Override
        public String getUrlPath(Instance host) {
            if (host.getCluster() == null) {
                throw new RuntimeException("Host must have cluster name in order to use ClusterConfigBasedUrlClosure");
            }
            String key = "turbine.instanceUrlSuffix." + host.getCluster();
            DynamicStringProperty urlClosureConfig = DynamicPropertyFactory.getInstance().getStringProperty(key, null);
            String url = urlClosureConfig.get();
            if (url == null) {
                url = this.defaultUrlClosureConfig.get();
            }
            if (url == null) {
                throw new RuntimeException("Config property: " + urlClosureConfig.getName() + " or " + this.defaultUrlClosureConfig.getName() + " must be set");
            }
            url = this.processAttributeReplacements(host, url);
            String protocolKey = "turbine.protocol." + host.getCluster();
            DynamicStringProperty protocolConfig = DynamicPropertyFactory.getInstance().getStringProperty(protocolKey, "http");
            return protocolConfig.get() + "://" + host.getHostname() + url;
        }

        private String processAttributeReplacements(Instance host, String url) {
            for (Map.Entry<String, String> attribute : host.getAttributes().entrySet()) {
                String placeholder = "{" + attribute.getKey() + "}";
                if (!url.contains(placeholder)) continue;
                url = url.replace(placeholder, attribute.getValue());
            }
            return url;
        }
    };

    public String getUrlPath(Instance var1);

    public static class UnitTest {
        @Test
        public void testConnectionPath() throws Exception {
            Instance host = new Instance("hostname", "testCluster", true);
            ConfigurationManager.getConfigInstance().setProperty("turbine.instanceUrlSuffix.testCluster", (Object)":80/turbine.stream");
            Assert.assertEquals((Object)"http://hostname:80/turbine.stream", (Object)ClusterConfigBasedUrlClosure.getUrlPath(host));
            Instance host2 = new Instance("hostname", "testCluster2", true);
            ConfigurationManager.getConfigInstance().setProperty("turbine.instanceUrlSuffix", (Object)":80/global.stream");
            Assert.assertEquals((Object)"http://hostname:80/global.stream", (Object)ClusterConfigBasedUrlClosure.getUrlPath(host2));
        }

        @Test
        public void testConnectionPathAttributeReplacement() throws Exception {
            Instance host = new Instance("hostname", "testCluster", true);
            host.getAttributes().put("server-port", "9090");
            ConfigurationManager.getConfigInstance().setProperty("turbine.instanceUrlSuffix.testCluster", (Object)":{server-port}/turbine.stream");
            Assert.assertEquals((Object)"http://hostname:9090/turbine.stream", (Object)ClusterConfigBasedUrlClosure.getUrlPath(host));
            Instance host2 = new Instance("hostname", "testCluster", true);
            host2.getAttributes().put("server-port", "9091");
            host2.getAttributes().put("server-ctx", "hystrix-event");
            ConfigurationManager.getConfigInstance().setProperty("turbine.instanceUrlSuffix.testCluster", (Object)":{server-port}/{server-ctx}/turbine.stream");
            Assert.assertEquals((Object)"http://hostname:9091/hystrix-event/turbine.stream", (Object)ClusterConfigBasedUrlClosure.getUrlPath(host2));
        }
    }
}

