/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.plugins;

import com.netflix.config.DynamicPropertyFactory;
import com.netflix.config.DynamicStringProperty;
import com.netflix.turbine.data.AggDataFromCluster;
import com.netflix.turbine.discovery.Instance;
import com.netflix.turbine.handler.PerformanceCriteria;
import com.netflix.turbine.handler.TurbineDataHandler;
import com.netflix.turbine.monitor.TurbineDataMonitor;
import com.netflix.turbine.monitor.cluster.AggregateClusterMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitor;
import com.netflix.turbine.monitor.cluster.ClusterMonitorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAggregatorFactory
implements ClusterMonitorFactory<AggDataFromCluster> {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAggregatorFactory.class);
    private static final DynamicStringProperty aggClusters = DynamicPropertyFactory.getInstance().getStringProperty("turbine.aggregator.clusterConfig", null);
    private TurbineDataHandler<AggDataFromCluster> StaticListener = new TurbineDataHandler<AggDataFromCluster>(){

        @Override
        public String getName() {
            return "StaticListener_For_Aggregator";
        }

        @Override
        public void handleData(Collection<AggDataFromCluster> stats) {
        }

        @Override
        public void handleHostLost(Instance host) {
        }

        @Override
        public PerformanceCriteria getCriteria() {
            return DefaultAggregatorFactory.this.NonCriticalCriteria;
        }
    };
    private PerformanceCriteria NonCriticalCriteria = new PerformanceCriteria(){

        @Override
        public boolean isCritical() {
            return false;
        }

        @Override
        public int getMaxQueueSize() {
            return 0;
        }

        @Override
        public int numThreads() {
            return 0;
        }
    };

    @Override
    public ClusterMonitor<AggDataFromCluster> getClusterMonitor(String name) {
        TurbineDataMonitor<AggDataFromCluster> clusterMonitor = AggregateClusterMonitor.AggregatorClusterMonitorConsole.findMonitor(name + "_agg");
        return (ClusterMonitor)clusterMonitor;
    }

    @Override
    public void initClusterMonitors() {
        for (String clusterName : this.getClusterNames()) {
            ClusterMonitor clusterMonitor = (ClusterMonitor)AggregateClusterMonitor.findOrRegisterAggregateMonitor(clusterName);
            clusterMonitor.registerListenertoClusterMonitor(this.StaticListener);
            try {
                clusterMonitor.startMonitor();
            }
            catch (Exception e) {
                logger.warn("Could not init cluster monitor for: " + clusterName);
                clusterMonitor.stopMonitor();
                clusterMonitor.getDispatcher().stopDispatcher();
            }
        }
    }

    @Override
    public void shutdownClusterMonitors() {
        for (String clusterName : this.getClusterNames()) {
            ClusterMonitor clusterMonitor = (ClusterMonitor)AggregateClusterMonitor.findOrRegisterAggregateMonitor(clusterName);
            clusterMonitor.stopMonitor();
            clusterMonitor.getDispatcher().stopDispatcher();
        }
    }

    private List<String> getClusterNames() {
        ArrayList<String> clusters = new ArrayList<String>();
        String clusterNames = aggClusters.get();
        if (clusterNames == null || clusterNames.trim().length() == 0) {
            clusters.add("default");
        } else {
            String[] parts;
            for (String s : parts = aggClusters.get().split(",")) {
                clusters.add(s);
            }
        }
        return clusters;
    }
}

