/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.turbine.streaming;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListSet;
import org.junit.Assert;
import org.junit.Test;

public class RelevanceKey {
    private final String name;
    private final List<RelevanceItem> items;
    private Long relevance = 0L;

    public RelevanceKey(String n, List<RelevanceItem> it, Map<String, Long> data) {
        this.name = n;
        this.items = it;
        this.computeRelevance(data);
    }

    public String getName() {
        return this.name;
    }

    public Long getRelevance() {
        return this.relevance;
    }

    private void computeRelevance(Map<String, Long> data) {
        double dRelevance = 0.0;
        for (RelevanceItem item : this.items) {
            Long value = data.get(item.attrKey);
            this.relevance = Math.round(dRelevance += item.getRelevance(value));
        }
    }

    public String toString() {
        return this.name + ": " + this.relevance;
    }

    public static class UnitTest {
        @Test
        public void testSortOnErrorPercentage() throws Exception {
            ArrayList<RelevanceItem> items = new ArrayList<RelevanceItem>();
            items.add(new RelevanceItem("errorPercentage", 100.0));
            HashMap<String, Long> attrs1 = new HashMap<String, Long>();
            attrs1.put("errorPercentage", 3L);
            RelevanceKey key1 = new RelevanceKey("AB", items, attrs1);
            HashMap<String, Long> attrs2 = new HashMap<String, Long>();
            attrs2.put("errorPercentage", 3L);
            RelevanceKey key2 = new RelevanceKey("Cinematch", items, attrs2);
            HashMap<String, Long> attrs3 = new HashMap<String, Long>();
            attrs3.put("errorPercentage", 1L);
            RelevanceKey key3 = new RelevanceKey("Subscriber", items, attrs3);
            ConcurrentSkipListSet<RelevanceKey> set = new ConcurrentSkipListSet<RelevanceKey>(new RelevanceComparator());
            set.add(key1);
            set.add(key2);
            set.add(key3);
            Iterator<RelevanceKey> iter = set.iterator();
            Assert.assertEquals((Object)"Subscriber", (Object)iter.next().name);
            Assert.assertEquals((Object)"AB", (Object)iter.next().name);
            Assert.assertEquals((Object)"Cinematch", (Object)iter.next().name);
        }

        @Test
        public void testSortOnErrorAndVolume() throws Exception {
            ArrayList<RelevanceItem> items = new ArrayList<RelevanceItem>();
            items.add(new RelevanceItem("errorPercentage", 100.0));
            items.add(new RelevanceItem("volume", 1.0));
            HashMap<String, Long> attrs1 = new HashMap<String, Long>();
            attrs1.put("errorPercentage", 3L);
            attrs1.put("volume", 100L);
            RelevanceKey key1 = new RelevanceKey("AB", items, attrs1);
            HashMap<String, Long> attrs2 = new HashMap<String, Long>();
            attrs2.put("errorPercentage", 3L);
            attrs2.put("volume", 0L);
            RelevanceKey key2 = new RelevanceKey("Cinematch", items, attrs2);
            HashMap<String, Long> attrs3 = new HashMap<String, Long>();
            attrs3.put("errorPercentage", 1L);
            attrs3.put("volume", 200L);
            RelevanceKey key3 = new RelevanceKey("Subscriber", items, attrs3);
            ConcurrentSkipListSet<RelevanceKey> set = new ConcurrentSkipListSet<RelevanceKey>(new RelevanceComparator());
            set.add(key1);
            set.add(key2);
            set.add(key3);
            Iterator<RelevanceKey> iter = set.iterator();
            Assert.assertEquals((Object)"Cinematch", (Object)iter.next().name);
            Assert.assertEquals((Object)"Subscriber", (Object)iter.next().name);
            Assert.assertEquals((Object)"AB", (Object)iter.next().name);
        }
    }

    public static class RelevanceComparator
    implements Comparator<RelevanceKey> {
        @Override
        public int compare(RelevanceKey arg0, RelevanceKey arg1) {
            int compareName = arg0.getName().compareTo(arg1.getName());
            int compareRelevance = arg0.getRelevance().compareTo(arg1.getRelevance());
            if (compareRelevance == 0) {
                return compareName;
            }
            return compareRelevance;
        }
    }

    public static class RelevanceItem {
        public final String attrKey;
        public final double weight;

        public RelevanceItem(String attrKey, double weight) {
            this.attrKey = attrKey;
            this.weight = weight;
        }

        public double getRelevance(Long value) {
            if (value == null) {
                return -1.0;
            }
            return this.weight * (double)value.longValue();
        }

        public String toString() {
            return " " + this.attrKey + ":" + this.weight;
        }
    }
}

