/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.zookeeper;

import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.registry.support.command.CommandFailbackRegistry;
import com.weibo.api.motan.registry.support.command.CommandListener;
import com.weibo.api.motan.registry.support.command.ServiceListener;
import com.weibo.api.motan.registry.zookeeper.ZkNodeType;
import com.weibo.api.motan.registry.zookeeper.ZkUtils;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.IZkStateListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.zookeeper.Watcher;

public class ZookeeperRegistry
extends CommandFailbackRegistry {
    private ZkClient zkClient;
    private Set<URL> availableServices = new ConcurrentHashSet();
    private ConcurrentHashMap<URL, ConcurrentHashMap<ServiceListener, IZkChildListener>> serviceListeners = new ConcurrentHashMap();
    private ConcurrentHashMap<URL, ConcurrentHashMap<CommandListener, IZkDataListener>> commandListeners = new ConcurrentHashMap();
    private final ReentrantLock clientLock = new ReentrantLock();
    private final ReentrantLock serverLock = new ReentrantLock();

    public ZookeeperRegistry(URL url, ZkClient client) {
        super(url);
        this.zkClient = client;
        IZkStateListener zkStateListener = new IZkStateListener(){

            public void handleStateChanged(Watcher.Event.KeeperState state) throws Exception {
            }

            public void handleNewSession() throws Exception {
                LoggerUtil.info((String)"zkRegistry get new session notify.");
                ZookeeperRegistry.this.reconnectService();
                ZookeeperRegistry.this.reconnectClient();
            }
        };
        this.zkClient.subscribeStateChanges(zkStateListener);
    }

    public ConcurrentHashMap<URL, ConcurrentHashMap<ServiceListener, IZkChildListener>> getServiceListeners() {
        return this.serviceListeners;
    }

    public ConcurrentHashMap<URL, ConcurrentHashMap<CommandListener, IZkDataListener>> getCommandListeners() {
        return this.commandListeners;
    }

    protected void subscribeService(final URL url, final ServiceListener serviceListener) {
        try {
            IZkChildListener zkChildListener;
            this.clientLock.lock();
            ConcurrentHashMap<ServiceListener, IZkChildListener> childChangeListeners = this.serviceListeners.get(url);
            if (childChangeListeners == null) {
                this.serviceListeners.putIfAbsent(url, new ConcurrentHashMap());
                childChangeListeners = this.serviceListeners.get(url);
            }
            if ((zkChildListener = childChangeListeners.get(serviceListener)) == null) {
                childChangeListeners.putIfAbsent(serviceListener, new IZkChildListener(){

                    public void handleChildChange(String parentPath, List<String> currentChilds) {
                        serviceListener.notifyService(url, ZookeeperRegistry.this.getUrl(), ZookeeperRegistry.this.nodeChildsToUrls(parentPath, currentChilds));
                        LoggerUtil.info((String)String.format("[ZookeeperRegistry] service list change: path=%s, currentChilds=%s", parentPath, currentChilds.toString()));
                    }
                });
                zkChildListener = childChangeListeners.get(serviceListener);
            }
            this.removeNode(url, ZkNodeType.CLIENT);
            this.createNode(url, ZkNodeType.CLIENT);
            String serverTypePath = ZkUtils.toNodeTypePath(url, ZkNodeType.AVAILABLE_SERVER);
            this.zkClient.subscribeChildChanges(serverTypePath, zkChildListener);
            LoggerUtil.info((String)String.format("[ZookeeperRegistry] subscribe service: path=%s, info=%s", ZkUtils.toNodePath(url, ZkNodeType.AVAILABLE_SERVER), url.toFullStr()));
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to subscribe %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()), e);
        }
        finally {
            this.clientLock.unlock();
        }
    }

    protected void subscribeCommand(final URL url, final CommandListener commandListener) {
        try {
            IZkDataListener zkDataListener;
            this.clientLock.lock();
            ConcurrentHashMap<CommandListener, IZkDataListener> dataChangeListeners = this.commandListeners.get(url);
            if (dataChangeListeners == null) {
                this.commandListeners.putIfAbsent(url, new ConcurrentHashMap());
                dataChangeListeners = this.commandListeners.get(url);
            }
            if ((zkDataListener = dataChangeListeners.get(commandListener)) == null) {
                dataChangeListeners.putIfAbsent(commandListener, new IZkDataListener(){

                    public void handleDataChange(String dataPath, Object data) throws Exception {
                        commandListener.notifyCommand(url, (String)data);
                        LoggerUtil.info((String)String.format("[ZookeeperRegistry] command data change: path=%s, command=%s", dataPath, (String)data));
                    }

                    public void handleDataDeleted(String dataPath) throws Exception {
                        commandListener.notifyCommand(url, null);
                        LoggerUtil.info((String)String.format("[ZookeeperRegistry] command deleted: path=%s", dataPath));
                    }
                });
                zkDataListener = dataChangeListeners.get(commandListener);
            }
            String commandPath = ZkUtils.toCommandPath(url);
            this.zkClient.subscribeDataChanges(commandPath, zkDataListener);
            LoggerUtil.info((String)String.format("[ZookeeperRegistry] subscribe command: path=%s, info=%s", commandPath, url.toFullStr()));
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to subscribe %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()), e);
        }
        finally {
            this.clientLock.unlock();
        }
    }

    protected void unsubscribeService(URL url, ServiceListener serviceListener) {
        try {
            IZkChildListener zkChildListener;
            this.clientLock.lock();
            Map childChangeListeners = this.serviceListeners.get(url);
            if (childChangeListeners != null && (zkChildListener = (IZkChildListener)childChangeListeners.get(serviceListener)) != null) {
                this.zkClient.unsubscribeChildChanges(ZkUtils.toNodeTypePath(url, ZkNodeType.CLIENT), zkChildListener);
                childChangeListeners.remove(serviceListener);
            }
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to unsubscribe service %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()), e);
        }
        finally {
            this.clientLock.unlock();
        }
    }

    protected void unsubscribeCommand(URL url, CommandListener commandListener) {
        try {
            IZkDataListener zkDataListener;
            this.clientLock.lock();
            Map dataChangeListeners = this.commandListeners.get(url);
            if (dataChangeListeners != null && (zkDataListener = (IZkDataListener)dataChangeListeners.get(commandListener)) != null) {
                this.zkClient.unsubscribeDataChanges(ZkUtils.toCommandPath(url), zkDataListener);
                dataChangeListeners.remove(commandListener);
            }
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to unsubscribe command %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()), e);
        }
        finally {
            this.clientLock.unlock();
        }
    }

    protected List<URL> discoverService(URL url) {
        try {
            String parentPath = ZkUtils.toNodeTypePath(url, ZkNodeType.AVAILABLE_SERVER);
            List<String> currentChilds = new ArrayList<String>();
            if (this.zkClient.exists(parentPath)) {
                currentChilds = this.zkClient.getChildren(parentPath);
            }
            return this.nodeChildsToUrls(parentPath, currentChilds);
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to discover service %s from zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()), e);
        }
    }

    protected String discoverCommand(URL url) {
        try {
            String commandPath = ZkUtils.toCommandPath(url);
            String command = "";
            if (this.zkClient.exists(commandPath)) {
                command = (String)this.zkClient.readData(commandPath);
            }
            return command;
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to discover command %s from zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()));
        }
    }

    protected void doRegister(URL url) {
        try {
            this.serverLock.lock();
            this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
            this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
            this.createNode(url, ZkNodeType.UNAVAILABLE_SERVER);
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to register %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()), e);
        }
        finally {
            this.serverLock.unlock();
        }
    }

    protected void doUnregister(URL url) {
        try {
            this.serverLock.lock();
            this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
            this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
        }
        catch (Throwable e) {
            throw new MotanFrameworkException(String.format("Failed to unregister %s to zookeeper(%s), cause: %s", url, this.getUrl(), e.getMessage()), e);
        }
        finally {
            this.serverLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAvailable(URL url) {
        try {
            this.serverLock.lock();
            if (url == null) {
                this.availableServices.addAll(this.getRegisteredServiceUrls());
                for (URL u : this.getRegisteredServiceUrls()) {
                    this.removeNode(u, ZkNodeType.AVAILABLE_SERVER);
                    this.removeNode(u, ZkNodeType.UNAVAILABLE_SERVER);
                    this.createNode(u, ZkNodeType.AVAILABLE_SERVER);
                }
            } else {
                this.availableServices.add(url);
                this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
                this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
                this.createNode(url, ZkNodeType.AVAILABLE_SERVER);
            }
        }
        finally {
            this.serverLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnavailable(URL url) {
        try {
            this.serverLock.lock();
            if (url == null) {
                this.availableServices.removeAll(this.getRegisteredServiceUrls());
                for (URL u : this.getRegisteredServiceUrls()) {
                    this.removeNode(u, ZkNodeType.AVAILABLE_SERVER);
                    this.removeNode(u, ZkNodeType.UNAVAILABLE_SERVER);
                    this.createNode(u, ZkNodeType.UNAVAILABLE_SERVER);
                }
            } else {
                this.availableServices.remove(url);
                this.removeNode(url, ZkNodeType.AVAILABLE_SERVER);
                this.removeNode(url, ZkNodeType.UNAVAILABLE_SERVER);
                this.createNode(url, ZkNodeType.UNAVAILABLE_SERVER);
            }
        }
        finally {
            this.serverLock.unlock();
        }
    }

    private List<URL> nodeChildsToUrls(String parentPath, List<String> currentChilds) {
        ArrayList<URL> urls = new ArrayList<URL>();
        if (currentChilds != null) {
            for (String node : currentChilds) {
                String nodePath = parentPath + "/" + node;
                String data = (String)this.zkClient.readData(nodePath, true);
                try {
                    URL url = URL.valueOf((String)data);
                    urls.add(url);
                }
                catch (Exception e) {
                    LoggerUtil.warn((String)String.format("Found malformed urls from ZookeeperRegistry, path=%s", nodePath), (Throwable)e);
                }
            }
        }
        return urls;
    }

    private void createNode(URL url, ZkNodeType nodeType) {
        String nodeTypePath = ZkUtils.toNodeTypePath(url, nodeType);
        if (!this.zkClient.exists(nodeTypePath)) {
            this.zkClient.createPersistent(nodeTypePath, true);
        }
        this.zkClient.createEphemeral(ZkUtils.toNodePath(url, nodeType), (Object)url.toFullStr());
    }

    private void removeNode(URL url, ZkNodeType nodeType) {
        String nodePath = ZkUtils.toNodePath(url, nodeType);
        if (this.zkClient.exists(nodePath)) {
            this.zkClient.delete(nodePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectService() {
        Collection allRegisteredServices = this.getRegisteredServiceUrls();
        if (allRegisteredServices != null && !allRegisteredServices.isEmpty()) {
            try {
                this.serverLock.lock();
                for (URL url : this.getRegisteredServiceUrls()) {
                    this.doRegister(url);
                }
                LoggerUtil.info((String)"[{}] reconnect: register services {}", (Object[])new Object[]{this.registryClassName, allRegisteredServices});
                for (URL url : this.availableServices) {
                    if (!this.getRegisteredServiceUrls().contains(url)) {
                        LoggerUtil.warn((String)"reconnect url not register. url:{}", (Object[])new Object[]{url});
                        continue;
                    }
                    this.doAvailable(url);
                }
                LoggerUtil.info((String)"[{}] reconnect: available services {}", (Object[])new Object[]{this.registryClassName, this.availableServices});
            }
            finally {
                this.serverLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconnectClient() {
        if (this.serviceListeners != null && !this.serviceListeners.isEmpty()) {
            try {
                URL url;
                this.clientLock.lock();
                for (Map.Entry<URL, ConcurrentHashMap<ServiceListener, IZkChildListener>> entry : this.serviceListeners.entrySet()) {
                    url = entry.getKey();
                    ConcurrentHashMap<ServiceListener, IZkChildListener> childChangeListeners = this.serviceListeners.get(url);
                    if (childChangeListeners == null) continue;
                    for (Map.Entry<ServiceListener, IZkChildListener> entry2 : childChangeListeners.entrySet()) {
                        this.subscribeService(url, entry2.getKey());
                    }
                }
                for (Map.Entry<URL, ConcurrentHashMap<ServiceListener, IZkChildListener>> entry : this.commandListeners.entrySet()) {
                    url = entry.getKey();
                    ConcurrentHashMap<CommandListener, IZkDataListener> dataChangeListeners = this.commandListeners.get(url);
                    if (dataChangeListeners == null) continue;
                    for (Map.Entry<ServiceListener, IZkChildListener> entry3 : dataChangeListeners.entrySet()) {
                        this.subscribeCommand(url, (CommandListener)entry3.getKey());
                    }
                }
                LoggerUtil.info((String)"[{}] reconnect all clients", (Object[])new Object[]{this.registryClassName});
            }
            finally {
                this.clientLock.unlock();
            }
        }
    }
}

