/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.Publication;
import java.util.HashMap;
import org.agrona.collections.Int2ObjectHashMap;

class ActivePublications {
    private final HashMap<String, Int2ObjectHashMap<Publication>> publicationsByChannelMap = new HashMap();

    ActivePublications() {
    }

    public Publication get(String channel, int streamId) {
        Int2ObjectHashMap<Publication> publicationByStreamIdMap = this.publicationsByChannelMap.get(channel);
        if (null == publicationByStreamIdMap) {
            return null;
        }
        return publicationByStreamIdMap.get(streamId);
    }

    public Publication put(String channel, int streamId, Publication publication) {
        Int2ObjectHashMap<Publication> publicationByStreamIdMap = this.publicationsByChannelMap.get(channel);
        if (null == publicationByStreamIdMap) {
            publicationByStreamIdMap = new Int2ObjectHashMap();
            this.publicationsByChannelMap.put(channel, publicationByStreamIdMap);
        }
        return publicationByStreamIdMap.put(streamId, publication);
    }

    public Publication remove(String channel, int streamId) {
        Int2ObjectHashMap<Publication> publicationByStreamIdMap = this.publicationsByChannelMap.get(channel);
        if (null == publicationByStreamIdMap) {
            return null;
        }
        Publication publication = publicationByStreamIdMap.remove(streamId);
        if (publicationByStreamIdMap.isEmpty()) {
            this.publicationsByChannelMap.remove(channel);
        }
        return publication;
    }

    public void close() {
        for (Int2ObjectHashMap<Publication> publications : this.publicationsByChannelMap.values()) {
            for (Publication publication : publications.values()) {
                publication.forceClose();
            }
        }
        this.publicationsByChannelMap.clear();
    }
}

