/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.AvailableImageHandler;
import io.aeron.ClientConductor;
import io.aeron.CncFileDescriptor;
import io.aeron.CommonContext;
import io.aeron.DriverProxy;
import io.aeron.ExclusivePublication;
import io.aeron.LogBuffersFactory;
import io.aeron.MappedLogBuffersFactory;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.exceptions.DriverTimeoutException;
import java.io.File;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.SleepingMillisIdleStrategy;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.SystemNanoClock;
import org.agrona.concurrent.broadcast.BroadcastReceiver;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;
import org.agrona.concurrent.ringbuffer.ManyToOneRingBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class Aeron
implements AutoCloseable {
    public static final ErrorHandler DEFAULT_ERROR_HANDLER = throwable -> {
        throwable.printStackTrace();
        if (throwable instanceof DriverTimeoutException) {
            System.err.printf("%n***%n*** Timeout from the MediaDriver - is it currently running? Exiting.%n***%n", new Object[0]);
            System.exit(-1);
        }
    };
    public static final long IDLE_SLEEP_MS = 16L;
    public static final long IDLE_SLEEP_NS = TimeUnit.MILLISECONDS.toNanos(16L);
    public static final long KEEPALIVE_INTERVAL_NS = TimeUnit.MILLISECONDS.toNanos(500L);
    public static final long INTER_SERVICE_TIMEOUT_NS = TimeUnit.SECONDS.toNanos(10L);
    public static final long PUBLICATION_CONNECTION_TIMEOUT_MS = TimeUnit.SECONDS.toMillis(5L);
    private final long clientId;
    private final Lock clientLock;
    private final Context ctx;
    private final ClientConductor conductor;
    private final AgentRunner conductorRunner;
    private final AgentInvoker conductorInvoker;
    private final RingBuffer commandBuffer;

    Aeron(Context ctx) {
        ctx.conclude();
        this.ctx = ctx;
        this.clientId = ctx.clientId();
        this.clientLock = ctx.clientLock();
        this.commandBuffer = ctx.toDriverBuffer();
        this.conductor = new ClientConductor(ctx);
        if (ctx.useConductorAgentInvoker()) {
            this.conductorInvoker = new AgentInvoker(ctx.errorHandler(), null, this.conductor);
            this.conductorRunner = null;
        } else {
            this.conductorInvoker = null;
            this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), null, this.conductor);
        }
    }

    public static Aeron connect() {
        return Aeron.connect(new Context());
    }

    public static Aeron connect(Context ctx) {
        try {
            Aeron aeron = new Aeron(ctx);
            if (ctx.useConductorAgentInvoker()) {
                aeron.conductorInvoker.start();
            } else {
                aeron.start(ctx.threadFactory);
            }
            return aeron;
        }
        catch (Exception ex) {
            ctx.close();
            throw ex;
        }
    }

    public Context context() {
        return this.ctx;
    }

    public long clientId() {
        return this.clientId;
    }

    public AgentInvoker conductorAgentInvoker() {
        return this.conductorInvoker;
    }

    @Override
    public void close() {
        this.clientLock.lock();
        try {
            if (null != this.conductorRunner) {
                this.conductorRunner.close();
            } else {
                this.conductorInvoker.close();
            }
            this.ctx.close();
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Publication addPublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            Publication publication = this.conductor.addPublication(channel, streamId);
            return publication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExclusivePublication addExclusivePublication(String channel, int streamId) {
        this.clientLock.lock();
        try {
            ExclusivePublication exclusivePublication = this.conductor.addExclusivePublication(channel, streamId);
            return exclusivePublication;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription addSubscription(String channel, int streamId) {
        this.clientLock.lock();
        try {
            Subscription subscription = this.conductor.addSubscription(channel, streamId);
            return subscription;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription addSubscription(String channel, int streamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.clientLock.lock();
        try {
            Subscription subscription = this.conductor.addSubscription(channel, streamId, availableImageHandler, unavailableImageHandler);
            return subscription;
        }
        finally {
            this.clientLock.unlock();
        }
    }

    public long nextCorrelationId() {
        if (this.conductor.isClosed()) {
            throw new IllegalStateException("Client is closed");
        }
        return this.commandBuffer.nextCorrelationId();
    }

    public CountersReader countersReader() {
        if (this.conductor.isClosed()) {
            throw new IllegalStateException("Client is closed");
        }
        return new CountersReader(this.ctx.countersMetaDataBuffer(), this.ctx.countersValuesBuffer(), StandardCharsets.US_ASCII);
    }

    private Aeron start(ThreadFactory threadFactory) {
        AgentRunner.startOnThread(this.conductorRunner, threadFactory);
        return this;
    }

    static void sleep(long durationMs) {
        try {
            Thread.sleep(durationMs);
        }
        catch (InterruptedException ignore) {
            Thread.interrupted();
        }
    }

    public static class Context
    extends CommonContext {
        private long clientId;
        private boolean useConductorAgentInvoker = false;
        private AgentInvoker driverAgentInvoker;
        private Lock clientLock;
        private EpochClock epochClock;
        private NanoClock nanoClock;
        private IdleStrategy idleStrategy;
        private CopyBroadcastReceiver toClientBuffer;
        private RingBuffer toDriverBuffer;
        private DriverProxy driverProxy;
        private MappedByteBuffer cncByteBuffer;
        private AtomicBuffer cncMetaDataBuffer;
        private LogBuffersFactory logBuffersFactory;
        private ErrorHandler errorHandler;
        private AvailableImageHandler availableImageHandler;
        private UnavailableImageHandler unavailableImageHandler;
        private long keepAliveInterval = KEEPALIVE_INTERVAL_NS;
        private long interServiceTimeout = 0L;
        private long publicationConnectionTimeout = PUBLICATION_CONNECTION_TIMEOUT_MS;
        private FileChannel.MapMode imageMapMode;
        private ThreadFactory threadFactory = Thread::new;

        @Override
        public Context conclude() {
            super.conclude();
            if (null == this.clientLock) {
                this.clientLock = new ReentrantLock();
            }
            if (null == this.epochClock) {
                this.epochClock = new SystemEpochClock();
            }
            if (null == this.nanoClock) {
                this.nanoClock = new SystemNanoClock();
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new SleepingMillisIdleStrategy(16L);
            }
            if (this.cncFile() != null) {
                this.connectToDriver();
            }
            if (null == this.toDriverBuffer) {
                this.toDriverBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (null == this.toClientBuffer) {
                this.toClientBuffer = new CopyBroadcastReceiver(new BroadcastReceiver(CncFileDescriptor.createToClientsBuffer(this.cncByteBuffer, this.cncMetaDataBuffer)));
            }
            if (this.countersMetaDataBuffer() == null) {
                this.countersMetaDataBuffer(CncFileDescriptor.createCountersMetaDataBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            if (this.countersValuesBuffer() == null) {
                this.countersValuesBuffer(CncFileDescriptor.createCountersValuesBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
            }
            this.interServiceTimeout = 0L == this.interServiceTimeout ? CncFileDescriptor.clientLivenessTimeout(this.cncMetaDataBuffer) : INTER_SERVICE_TIMEOUT_NS;
            if (null == this.logBuffersFactory) {
                this.logBuffersFactory = new MappedLogBuffersFactory();
            }
            if (null == this.errorHandler) {
                this.errorHandler = DEFAULT_ERROR_HANDLER;
            }
            if (null == this.imageMapMode) {
                this.imageMapMode = FileChannel.MapMode.READ_ONLY;
            }
            if (null == this.driverProxy) {
                this.clientId = this.toDriverBuffer.nextCorrelationId();
                this.driverProxy = new DriverProxy(this.toDriverBuffer, this.clientId);
            }
            return this;
        }

        public long clientId() {
            return this.clientId;
        }

        public Context useConductorAgentInvoker(boolean useConductorAgentInvoker) {
            this.useConductorAgentInvoker = useConductorAgentInvoker;
            return this;
        }

        public boolean useConductorAgentInvoker() {
            return this.useConductorAgentInvoker;
        }

        public Context driverAgentInvoker(AgentInvoker driverAgentInvoker) {
            this.driverAgentInvoker = driverAgentInvoker;
            return this;
        }

        public AgentInvoker driverAgentInvoker() {
            return this.driverAgentInvoker;
        }

        public Context clientLock(Lock lock) {
            this.clientLock = lock;
            return this;
        }

        public Lock clientLock() {
            return this.clientLock;
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        public Context nanoClock(NanoClock clock) {
            this.nanoClock = clock;
            return this;
        }

        public NanoClock nanoClock() {
            return this.nanoClock;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context toClientBuffer(CopyBroadcastReceiver toClientBuffer) {
            this.toClientBuffer = toClientBuffer;
            return this;
        }

        public CopyBroadcastReceiver toClientBuffer() {
            return this.toClientBuffer;
        }

        public Context toDriverBuffer(RingBuffer toDriverBuffer) {
            this.toDriverBuffer = toDriverBuffer;
            return this;
        }

        public RingBuffer toDriverBuffer() {
            return this.toDriverBuffer;
        }

        public Context driverProxy(DriverProxy driverProxy) {
            this.driverProxy = driverProxy;
            return this;
        }

        public DriverProxy driverProxy() {
            return this.driverProxy;
        }

        public Context logBuffersFactory(LogBuffersFactory logBuffersFactory) {
            this.logBuffersFactory = logBuffersFactory;
            return this;
        }

        public LogBuffersFactory logBuffersFactory() {
            return this.logBuffersFactory;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context availableImageHandler(AvailableImageHandler handler) {
            this.availableImageHandler = handler;
            return this;
        }

        public AvailableImageHandler availableImageHandler() {
            return this.availableImageHandler;
        }

        public Context unavailableImageHandler(UnavailableImageHandler handler) {
            this.unavailableImageHandler = handler;
            return this;
        }

        public UnavailableImageHandler unavailableImageHandler() {
            return this.unavailableImageHandler;
        }

        public Context keepAliveInterval(long value) {
            this.keepAliveInterval = value;
            return this;
        }

        public long keepAliveInterval() {
            return this.keepAliveInterval;
        }

        @Override
        public Context driverTimeoutMs(long value) {
            super.driverTimeoutMs(value);
            return this;
        }

        public Context interServiceTimeout(long interServiceTimeout) {
            this.interServiceTimeout = interServiceTimeout;
            return this;
        }

        public long interServiceTimeout() {
            return this.interServiceTimeout;
        }

        @Override
        public Context aeronDirectoryName(String dirName) {
            super.aeronDirectoryName(dirName);
            return this;
        }

        public Context publicationConnectionTimeout(long value) {
            this.publicationConnectionTimeout = value;
            return this;
        }

        public long publicationConnectionTimeout() {
            return this.publicationConnectionTimeout;
        }

        public Context imageMapMode(FileChannel.MapMode imageMapMode) {
            this.imageMapMode = imageMapMode;
            return this;
        }

        public FileChannel.MapMode imageMapMode() {
            return this.imageMapMode;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        @Override
        public void close() {
            IoUtil.unmap(this.cncByteBuffer);
            this.cncByteBuffer = null;
            super.close();
        }

        private void connectToDriver() {
            block9: {
                ManyToOneRingBuffer ringBuffer;
                long startTimeMs = this.epochClock.time();
                File cncFile = this.cncFile();
                while (true) {
                    int cncVersion;
                    if (!cncFile.exists()) {
                        if (this.epochClock.time() > startTimeMs + this.driverTimeoutMs()) {
                            throw new DriverTimeoutException("CnC file not found: " + cncFile.getName());
                        }
                        Aeron.sleep(16L);
                        continue;
                    }
                    this.cncByteBuffer = IoUtil.mapExistingFile(this.cncFile(), "cnc.dat");
                    this.cncMetaDataBuffer = CncFileDescriptor.createMetaDataBuffer(this.cncByteBuffer);
                    while (0 == (cncVersion = this.cncMetaDataBuffer.getIntVolatile(CncFileDescriptor.cncVersionOffset(0)))) {
                        if (this.epochClock.time() > startTimeMs + this.driverTimeoutMs()) {
                            throw new DriverTimeoutException("CnC file is created but not initialised.");
                        }
                        Aeron.sleep(1L);
                    }
                    if (7 != cncVersion) {
                        throw new IllegalStateException("CnC file version not supported: version=" + cncVersion);
                    }
                    ringBuffer = new ManyToOneRingBuffer(CncFileDescriptor.createToDriverBuffer(this.cncByteBuffer, this.cncMetaDataBuffer));
                    while (0L == ringBuffer.consumerHeartbeatTime()) {
                        if (this.epochClock.time() > startTimeMs + this.driverTimeoutMs()) {
                            throw new DriverTimeoutException("No driver heartbeat detected.");
                        }
                        Aeron.sleep(1L);
                    }
                    long timeMs = this.epochClock.time();
                    if (ringBuffer.consumerHeartbeatTime() >= timeMs - this.driverTimeoutMs()) break;
                    if (timeMs > startTimeMs + this.driverTimeoutMs()) {
                        throw new DriverTimeoutException("No driver heartbeat detected.");
                    }
                    IoUtil.unmap(this.cncByteBuffer);
                    this.cncByteBuffer = null;
                    this.cncMetaDataBuffer = null;
                    Aeron.sleep(100L);
                }
                if (null != this.toDriverBuffer) break block9;
                this.toDriverBuffer = ringBuffer;
            }
        }
    }
}

