/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.ControlledFragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class ControlledFragmentAssembler
implements ControlledFragmentHandler {
    private final boolean isDirectByteBuffer;
    private final int initialBufferLength;
    private final ControlledFragmentHandler delegate;
    private final Int2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Int2ObjectHashMap();

    public ControlledFragmentAssembler(ControlledFragmentHandler delegate) {
        this(delegate, 0, false);
    }

    public ControlledFragmentAssembler(ControlledFragmentHandler delegate, int initialBufferLength) {
        this(delegate, initialBufferLength, false);
    }

    public ControlledFragmentAssembler(ControlledFragmentHandler delegate, int initialBufferLength, boolean isDirectByteBuffer) {
        this.initialBufferLength = initialBufferLength;
        this.delegate = delegate;
        this.isDirectByteBuffer = isDirectByteBuffer;
    }

    public ControlledFragmentHandler delegate() {
        return this.delegate;
    }

    public boolean isDirectByteBuffer() {
        return this.isDirectByteBuffer;
    }

    @Override
    public ControlledFragmentHandler.Action onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        byte flags = header.flags();
        ControlledFragmentHandler.Action action = ControlledFragmentHandler.Action.CONTINUE;
        if ((flags & 0xFFFFFFC0) == -64) {
            action = this.delegate.onFragment(buffer, offset, length, header);
        } else if ((flags & 0xFFFFFF80) == -128) {
            BufferBuilder builder = this.getBufferBuilder(header.sessionId());
            builder.reset().append(buffer, offset, length);
        } else {
            BufferBuilder builder = this.builderBySessionIdMap.get(header.sessionId());
            if (null != builder && builder.limit() != 0) {
                int limit = builder.limit();
                builder.append(buffer, offset, length);
                if ((flags & 0x40) == 64) {
                    int msgLength = builder.limit();
                    action = this.delegate.onFragment(builder.buffer(), 0, msgLength, header);
                    if (ControlledFragmentHandler.Action.ABORT == action) {
                        builder.limit(limit);
                    } else {
                        builder.reset();
                    }
                }
            }
        }
        return action;
    }

    public boolean freeSessionBuffer(int sessionId) {
        return null != this.builderBySessionIdMap.remove(sessionId);
    }

    public void clear() {
        this.builderBySessionIdMap.clear();
    }

    private BufferBuilder getBufferBuilder(int sessionId) {
        BufferBuilder bufferBuilder = this.builderBySessionIdMap.get(sessionId);
        if (null == bufferBuilder) {
            bufferBuilder = new BufferBuilder(this.initialBufferLength, this.isDirectByteBuffer);
            this.builderBySessionIdMap.put(sessionId, bufferBuilder);
        }
        return bufferBuilder;
    }
}

