/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.DriverEventsListener;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.ErrorResponseFlyweight;
import io.aeron.command.ImageBuffersReadyFlyweight;
import io.aeron.command.ImageMessageFlyweight;
import io.aeron.command.PublicationBuffersReadyFlyweight;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.MessageHandler;
import org.agrona.concurrent.broadcast.CopyBroadcastReceiver;

class DriverEventsAdapter
implements MessageHandler {
    private final CopyBroadcastReceiver broadcastReceiver;
    private final ErrorResponseFlyweight errorResponse = new ErrorResponseFlyweight();
    private final PublicationBuffersReadyFlyweight publicationReady = new PublicationBuffersReadyFlyweight();
    private final ImageBuffersReadyFlyweight imageReady = new ImageBuffersReadyFlyweight();
    private final CorrelatedMessageFlyweight correlatedMessage = new CorrelatedMessageFlyweight();
    private final ImageMessageFlyweight imageMessage = new ImageMessageFlyweight();
    private final DriverEventsListener listener;
    private long activeCorrelationId;
    private long lastReceivedCorrelationId;
    private String expectedChannel;

    DriverEventsAdapter(CopyBroadcastReceiver broadcastReceiver, DriverEventsListener listener) {
        this.broadcastReceiver = broadcastReceiver;
        this.listener = listener;
    }

    public int receive(long activeCorrelationId, String expectedChannel) {
        this.activeCorrelationId = activeCorrelationId;
        this.lastReceivedCorrelationId = -1L;
        this.expectedChannel = expectedChannel;
        return this.broadcastReceiver.receive(this);
    }

    public long lastReceivedCorrelationId() {
        return this.lastReceivedCorrelationId;
    }

    @Override
    public void onMessage(int msgTypeId, MutableDirectBuffer buffer, int index, int length) {
        switch (msgTypeId) {
            case 3841: {
                this.errorResponse.wrap(buffer, index);
                long correlationId = this.errorResponse.offendingCommandCorrelationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onError(correlationId, this.errorResponse.errorCode(), this.errorResponse.errorMessage());
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3842: {
                this.imageReady.wrap(buffer, index);
                this.listener.onAvailableImage(this.imageReady.correlationId(), this.imageReady.streamId(), this.imageReady.sessionId(), this.imageReady.subscriberRegistrationId(), this.imageReady.subscriberPositionId(), this.imageReady.logFileName(), this.imageReady.sourceIdentity());
                break;
            }
            case 3843: {
                this.publicationReady.wrap(buffer, index);
                long correlationId = this.publicationReady.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onNewPublication(correlationId, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.expectedChannel, this.publicationReady.logFileName());
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3844: {
                this.correlatedMessage.wrap(buffer, index);
                long correlationId = this.correlatedMessage.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
            case 3845: {
                this.imageMessage.wrap(buffer, index);
                this.listener.onUnavailableImage(this.imageMessage.correlationId(), this.imageMessage.streamId());
                break;
            }
            case 3846: {
                this.publicationReady.wrap(buffer, index);
                long correlationId = this.publicationReady.correlationId();
                if (correlationId != this.activeCorrelationId) break;
                this.listener.onNewExclusivePublication(correlationId, this.publicationReady.registrationId(), this.publicationReady.streamId(), this.publicationReady.sessionId(), this.publicationReady.publicationLimitCounterId(), this.expectedChannel, this.publicationReady.logFileName());
                this.lastReceivedCorrelationId = correlationId;
                break;
            }
        }
    }
}

