/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.command.DestinationMessageFlyweight;
import io.aeron.command.PublicationMessageFlyweight;
import io.aeron.command.RemoveMessageFlyweight;
import io.aeron.command.SubscriptionMessageFlyweight;
import org.agrona.BufferUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.ringbuffer.RingBuffer;

public class DriverProxy {
    public static final int MSG_BUFFER_CAPACITY = 1024;
    private final UnsafeBuffer buffer = new UnsafeBuffer(BufferUtil.allocateDirectAligned(1024, 128));
    private final PublicationMessageFlyweight publicationMessage = new PublicationMessageFlyweight();
    private final SubscriptionMessageFlyweight subscriptionMessage = new SubscriptionMessageFlyweight();
    private final RemoveMessageFlyweight removeMessage = new RemoveMessageFlyweight();
    private final CorrelatedMessageFlyweight correlatedMessage = new CorrelatedMessageFlyweight();
    private final DestinationMessageFlyweight destinationMessage = new DestinationMessageFlyweight();
    private final RingBuffer toDriverCommandBuffer;

    public DriverProxy(RingBuffer toDriverCommandBuffer, long clientId) {
        this.toDriverCommandBuffer = toDriverCommandBuffer;
        this.publicationMessage.wrap(this.buffer, 0);
        this.subscriptionMessage.wrap(this.buffer, 0);
        this.correlatedMessage.wrap(this.buffer, 0);
        this.removeMessage.wrap(this.buffer, 0);
        this.destinationMessage.wrap(this.buffer, 0);
        this.correlatedMessage.clientId(clientId);
    }

    public long timeOfLastDriverKeepaliveMs() {
        return this.toDriverCommandBuffer.consumerHeartbeatTime();
    }

    public long addPublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.publicationMessage.correlationId(correlationId);
        this.publicationMessage.streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(1, this.buffer, 0, this.publicationMessage.length())) {
            throw new IllegalStateException("Could not write add publication command");
        }
        return correlationId;
    }

    public long addExclusivePublication(String channel, int streamId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.publicationMessage.correlationId(correlationId);
        this.publicationMessage.streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(3, this.buffer, 0, this.publicationMessage.length())) {
            throw new IllegalStateException("Could not write add exclusive publication command");
        }
        return correlationId;
    }

    public long removePublication(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(2, this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new IllegalStateException("Could not write remove publication command");
        }
        return correlationId;
    }

    public long addSubscription(String channel, int streamId) {
        long registrationId = -1L;
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.subscriptionMessage.correlationId(correlationId);
        this.subscriptionMessage.registrationCorrelationId(-1L).streamId(streamId).channel(channel);
        if (!this.toDriverCommandBuffer.write(4, this.buffer, 0, this.subscriptionMessage.length())) {
            throw new IllegalStateException("Could not write add subscription command");
        }
        return correlationId;
    }

    public long removeSubscription(long registrationId) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.removeMessage.registrationId(registrationId).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(5, this.buffer, 0, RemoveMessageFlyweight.length())) {
            throw new IllegalStateException("Could not write remove subscription message");
        }
        return correlationId;
    }

    public void sendClientKeepalive() {
        this.correlatedMessage.correlationId(0L);
        if (!this.toDriverCommandBuffer.write(6, this.buffer, 0, 16)) {
            throw new IllegalStateException("Could not send client keepalive command");
        }
    }

    public long addDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.destinationMessage.registrationCorrelationId(registrationId).channel(endpointChannel).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(7, this.buffer, 0, this.destinationMessage.length())) {
            throw new IllegalStateException("Could not write destination command");
        }
        return correlationId;
    }

    public long removeDestination(long registrationId, String endpointChannel) {
        long correlationId = this.toDriverCommandBuffer.nextCorrelationId();
        this.destinationMessage.registrationCorrelationId(registrationId).channel(endpointChannel).correlationId(correlationId);
        if (!this.toDriverCommandBuffer.write(8, this.buffer, 0, this.destinationMessage.length())) {
            throw new IllegalStateException("Could not write destination command");
        }
        return correlationId;
    }
}

