/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.LogBuffers;
import io.aeron.ReservedValueSupplier;
import io.aeron.logbuffer.ExclusiveBufferClaim;
import io.aeron.logbuffer.ExclusiveTermAppender;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.HeaderWriter;
import io.aeron.logbuffer.LogBufferDescriptor;
import org.agrona.DirectBuffer;
import org.agrona.ManagedResource;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.ReadablePosition;

public class ExclusivePublication
implements AutoCloseable {
    public static final long NOT_CONNECTED = -1L;
    public static final long BACK_PRESSURED = -2L;
    public static final long ADMIN_ACTION = -3L;
    public static final long CLOSED = -4L;
    public static final long MAX_POSITION_EXCEEDED = -5L;
    private final long originalRegistrationId;
    private final long registrationId;
    private final long maxPossiblePosition;
    private final int streamId;
    private final int sessionId;
    private final int initialTermId;
    private final int termBufferLength;
    private final int maxMessageLength;
    private final int maxPayloadLength;
    private final int positionBitsToShift;
    private long termBeginPosition;
    private int activePartitionIndex;
    private int termId;
    private int termOffset;
    private volatile boolean isClosed = false;
    private final ExclusiveTermAppender[] termAppenders = new ExclusiveTermAppender[3];
    private final ReadablePosition positionLimit;
    private final UnsafeBuffer logMetaDataBuffer;
    private final HeaderWriter headerWriter;
    private final LogBuffers logBuffers;
    private final ClientConductor conductor;
    private final String channel;

    ExclusivePublication(ClientConductor clientConductor, String channel, int streamId, int sessionId, ReadablePosition positionLimit, LogBuffers logBuffers, long originalRegistrationId, long registrationId) {
        int activeIndex;
        int termLength;
        UnsafeBuffer[] buffers = logBuffers.termBuffers();
        UnsafeBuffer logMetaDataBuffer = logBuffers.metaDataBuffer();
        for (int i = 0; i < 3; ++i) {
            this.termAppenders[i] = new ExclusiveTermAppender(buffers[i], logMetaDataBuffer, i);
        }
        this.termBufferLength = termLength = logBuffers.termLength();
        this.maxPayloadLength = LogBufferDescriptor.mtuLength(logMetaDataBuffer) - 32;
        this.maxMessageLength = FrameDescriptor.computeExclusiveMaxMessageLength(termLength);
        this.maxPossiblePosition = (long)termLength * 0x80000000L;
        this.conductor = clientConductor;
        this.channel = channel;
        this.streamId = streamId;
        this.sessionId = sessionId;
        this.logMetaDataBuffer = logMetaDataBuffer;
        this.originalRegistrationId = originalRegistrationId;
        this.registrationId = registrationId;
        this.positionLimit = positionLimit;
        this.logBuffers = logBuffers;
        this.positionBitsToShift = Integer.numberOfTrailingZeros(termLength);
        this.headerWriter = new HeaderWriter(LogBufferDescriptor.defaultFrameHeader(logMetaDataBuffer));
        this.initialTermId = LogBufferDescriptor.initialTermId(logMetaDataBuffer);
        this.activePartitionIndex = activeIndex = LogBufferDescriptor.activePartitionIndex(logMetaDataBuffer);
        long rawTail = LogBufferDescriptor.rawTail(logMetaDataBuffer, activeIndex);
        this.termId = LogBufferDescriptor.termId(rawTail);
        this.termOffset = LogBufferDescriptor.termOffset(rawTail);
        this.termBeginPosition = LogBufferDescriptor.computeTermBeginPosition(this.termId, this.positionBitsToShift, this.initialTermId);
    }

    public int termBufferLength() {
        return this.termBufferLength;
    }

    public long maxPossiblePosition() {
        return this.maxPossiblePosition;
    }

    public String channel() {
        return this.channel;
    }

    public int streamId() {
        return this.streamId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int initialTermId() {
        return this.initialTermId;
    }

    public int maxMessageLength() {
        return this.maxMessageLength;
    }

    public int maxPayloadLength() {
        return this.maxPayloadLength;
    }

    public long originalRegistrationId() {
        return this.originalRegistrationId;
    }

    public boolean isOriginal() {
        return this.originalRegistrationId == this.registrationId;
    }

    public long registrationId() {
        return this.registrationId;
    }

    public boolean isConnected() {
        return !this.isClosed && this.conductor.isPublicationConnected(LogBufferDescriptor.timeOfLastStatusMessage(this.logMetaDataBuffer));
    }

    @Override
    public void close() {
        this.conductor.clientLock().lock();
        try {
            if (!this.isClosed) {
                this.isClosed = true;
                this.conductor.releasePublication(this);
            }
        }
        finally {
            this.conductor.clientLock().unlock();
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void forceClose() {
        if (!this.isClosed) {
            this.isClosed = true;
            this.conductor.asyncReleasePublication(this.registrationId);
            this.conductor.lingerResource(this.managedResource());
        }
    }

    public long position() {
        if (this.isClosed) {
            return -4L;
        }
        long rawTail = LogBufferDescriptor.rawTailVolatile(this.logMetaDataBuffer);
        int termOffset = LogBufferDescriptor.termOffset(rawTail, this.logBuffers.termLength());
        return LogBufferDescriptor.computePosition(LogBufferDescriptor.termId(rawTail), termOffset, this.positionBitsToShift, this.initialTermId);
    }

    public long positionLimit() {
        if (this.isClosed) {
            return -4L;
        }
        return this.positionLimit.getVolatile();
    }

    public long offer(DirectBuffer buffer) {
        return this.offer(buffer, 0, buffer.capacity());
    }

    public long offer(DirectBuffer buffer, int offset, int length) {
        return this.offer(buffer, offset, length, null);
    }

    public long offer(DirectBuffer buffer, int offset, int length, ReservedValueSupplier reservedValueSupplier) {
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result;
                if (length <= this.maxPayloadLength) {
                    result = termAppender.appendUnfragmentedMessage(this.termId, this.termOffset, this.headerWriter, buffer, offset, length, reservedValueSupplier);
                } else {
                    this.checkForMaxMessageLength(length);
                    result = termAppender.appendFragmentedMessage(this.termId, this.termOffset, this.headerWriter, buffer, offset, length, this.maxPayloadLength, reservedValueSupplier);
                }
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long tryClaim(int length, ExclusiveBufferClaim bufferClaim) {
        this.checkForMaxPayloadLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result = termAppender.claim(this.termId, this.termOffset, this.headerWriter, length, bufferClaim);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public long appendPadding(int length) {
        this.checkForMaxMessageLength(length);
        long newPosition = -4L;
        if (!this.isClosed) {
            long limit = this.positionLimit.getVolatile();
            ExclusiveTermAppender termAppender = this.termAppenders[this.activePartitionIndex];
            long position = this.termBeginPosition + (long)this.termOffset;
            if (position < limit) {
                int result = termAppender.appendPadding(this.termId, this.termOffset, this.headerWriter, length);
                newPosition = this.newPosition(result);
            } else {
                newPosition = this.backPressureStatus(position, length);
            }
        }
        return newPosition;
    }

    public void addDestination(String endpointChannel) {
        this.conductor.clientLock().lock();
        try {
            this.conductor.addDestination(this.registrationId, endpointChannel);
        }
        finally {
            this.conductor.clientLock().unlock();
        }
    }

    public void removeDestination(String endpointChannel) {
        this.conductor.clientLock().lock();
        try {
            this.conductor.removeDestination(this.registrationId, endpointChannel);
        }
        finally {
            this.conductor.clientLock().unlock();
        }
    }

    private long newPosition(int resultingOffset) {
        if (resultingOffset > 0) {
            this.termOffset = resultingOffset;
            return this.termBeginPosition + (long)resultingOffset;
        }
        if (this.termBeginPosition + (long)this.termBufferLength >= this.maxPossiblePosition()) {
            return -5L;
        }
        int nextIndex = LogBufferDescriptor.nextPartitionIndex(this.activePartitionIndex);
        int nextTermId = this.termId + 1;
        this.activePartitionIndex = nextIndex;
        this.termOffset = 0;
        this.termId = nextTermId;
        this.termBeginPosition = LogBufferDescriptor.computeTermBeginPosition(nextTermId, this.positionBitsToShift, this.initialTermId);
        LogBufferDescriptor.initialiseTailWithTermId(this.logMetaDataBuffer, nextIndex, nextTermId);
        LogBufferDescriptor.activePartitionIndexOrdered(this.logMetaDataBuffer, nextIndex);
        return -3L;
    }

    private long backPressureStatus(long currentPosition, int messageLength) {
        long status = -1L;
        if (currentPosition + (long)messageLength >= this.maxPossiblePosition) {
            status = -5L;
        } else if (this.conductor.isPublicationConnected(LogBufferDescriptor.timeOfLastStatusMessage(this.logMetaDataBuffer))) {
            status = -2L;
        }
        return status;
    }

    private void checkForMaxPayloadLength(int length) {
        if (length > this.maxPayloadLength) {
            throw new IllegalArgumentException("Claim exceeds maxPayloadLength of " + this.maxPayloadLength + ", length=" + length);
        }
    }

    private void checkForMaxMessageLength(int length) {
        if (length > this.maxMessageLength) {
            throw new IllegalArgumentException("Message exceeds maxMessageLength of " + this.maxMessageLength + ", length=" + length);
        }
    }

    ManagedResource managedResource() {
        return new PublicationManagedResource();
    }

    private class PublicationManagedResource
    implements ManagedResource {
        private long timeOfLastStateChange = 0L;

        private PublicationManagedResource() {
        }

        @Override
        public void timeOfLastStateChange(long time) {
            this.timeOfLastStateChange = time;
        }

        @Override
        public long timeOfLastStateChange() {
            return this.timeOfLastStateChange;
        }

        @Override
        public void delete() {
            ExclusivePublication.this.logBuffers.close();
        }
    }
}

