/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class ImageFragmentAssembler
implements FragmentHandler {
    private final FragmentHandler delegate;
    private final BufferBuilder builder;

    public ImageFragmentAssembler(FragmentHandler delegate) {
        this(delegate, 0, false);
    }

    public ImageFragmentAssembler(FragmentHandler delegate, int initialBufferLength) {
        this.delegate = delegate;
        this.builder = new BufferBuilder(initialBufferLength, false);
    }

    public ImageFragmentAssembler(FragmentHandler delegate, int initialBufferLength, boolean isDirectByteBuffer) {
        this.delegate = delegate;
        this.builder = new BufferBuilder(initialBufferLength, isDirectByteBuffer);
    }

    public FragmentHandler delegate() {
        return this.delegate;
    }

    BufferBuilder bufferBuilder() {
        return this.builder;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        byte flags = header.flags();
        if ((flags & 0xFFFFFFC0) == -64) {
            this.delegate.onFragment(buffer, offset, length, header);
        } else {
            this.handleFragment(buffer, offset, length, header, flags);
        }
    }

    private void handleFragment(DirectBuffer buffer, int offset, int length, Header header, byte flags) {
        if ((flags & 0xFFFFFF80) == -128) {
            this.builder.reset().append(buffer, offset, length);
        } else {
            this.builder.append(buffer, offset, length);
            if ((flags & 0x40) == 64) {
                int msgLength = this.builder.limit();
                this.delegate.onFragment(this.builder.buffer(), 0, msgLength, header);
                this.builder.reset();
            }
        }
    }
}

