/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ArchiveThreadingMode;
import io.aeron.archive.DedicatedModeArchiveConductor;
import io.aeron.archive.SharedModeArchiveConductor;
import io.aeron.archive.client.AeronArchive;
import java.io.File;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.IoUtil;
import org.agrona.LangUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.ControllableIdleStrategy;
import org.agrona.concurrent.CountedErrorHandler;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NoOpLock;
import org.agrona.concurrent.SystemEpochClock;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.StatusIndicator;

public final class Archive
implements AutoCloseable {
    private final Context ctx;
    private final AgentRunner conductorRunner;
    private final AgentInvoker conductorInvoker;
    private final Aeron aeron;

    private Archive(Context ctx) {
        ArchiveConductor conductor;
        this.ctx = ctx;
        ctx.aeronContext.errorHandler(ctx.countedErrorHandler()).driverAgentInvoker(ctx.mediaDriverAgentInvoker()).clientLock(new NoOpLock());
        this.aeron = Aeron.connect(ctx.aeronContext);
        ctx.conclude();
        ArchiveConductor archiveConductor = conductor = ArchiveThreadingMode.DEDICATED == ctx.threadingMode() ? new DedicatedModeArchiveConductor(this.aeron, ctx) : new SharedModeArchiveConductor(this.aeron, ctx);
        if (ArchiveThreadingMode.INVOKER == ctx.threadingMode()) {
            this.conductorInvoker = new AgentInvoker(ctx.errorHandler(), ctx.errorCounter(), conductor);
            this.conductorRunner = null;
        } else {
            this.conductorInvoker = null;
            this.conductorRunner = new AgentRunner(ctx.idleStrategy(), ctx.errorHandler(), ctx.errorCounter(), conductor);
        }
    }

    public Context context() {
        return this.ctx;
    }

    @Override
    public void close() {
        CloseHelper.close(this.conductorInvoker);
        CloseHelper.close(this.conductorRunner);
        CloseHelper.close(this.aeron);
    }

    private Archive start() {
        if (ArchiveThreadingMode.INVOKER == this.ctx.threadingMode()) {
            this.conductorInvoker.start();
        } else {
            AgentRunner.startOnThread(this.conductorRunner, this.ctx.threadFactory());
        }
        return this;
    }

    public AgentInvoker invoker() {
        return this.conductorInvoker;
    }

    public static Archive launch() {
        return Archive.launch(new Context());
    }

    public static Archive launch(Context ctx) {
        return new Archive(ctx).start();
    }

    static int segmentFileIndex(long startPosition, long position, int segmentFileLength) {
        return (int)((position - startPosition) / (long)segmentFileLength);
    }

    static String segmentFileName(long recordingId, int segmentIndex) {
        return recordingId + "." + segmentIndex + ".rec";
    }

    public static class Context {
        private final Aeron.Context aeronContext;
        private File archiveDir;
        private String controlChannel;
        private int controlStreamId;
        private String recordingEventsChannel;
        private int recordingEventsStreamId;
        private int segmentFileLength;
        private int fileSyncLevel;
        private ArchiveThreadingMode threadingMode;
        private ThreadFactory threadFactory = Thread::new;
        private Supplier<IdleStrategy> idleStrategySupplier;
        private EpochClock epochClock;
        private ErrorHandler errorHandler;
        private CountersManager countersManager;
        private AtomicCounter errorCounter;
        private CountedErrorHandler countedErrorHandler;
        private AgentInvoker mediaDriverAgentInvoker;
        private int maxConcurrentRecordings;
        private int maxConcurrentReplays;

        public Context() {
            this(new Aeron.Context());
        }

        public Context(Aeron.Context aeronContext) {
            this.aeronContext = aeronContext;
            aeronContext.useConductorAgentInvoker(true);
            this.controlChannel(AeronArchive.Configuration.controlChannel());
            this.controlStreamId(AeronArchive.Configuration.controlStreamId());
            this.recordingEventsChannel(AeronArchive.Configuration.recordingEventsChannel());
            this.recordingEventsStreamId(AeronArchive.Configuration.recordingEventsStreamId());
            this.segmentFileLength(Configuration.segmentFileLength());
            this.fileSyncLevel(Configuration.fileSyncLevel());
            this.threadingMode(Configuration.threadingMode());
            this.maxConcurrentRecordings(Configuration.maxConcurrentRecordings());
            this.maxConcurrentReplays(Configuration.maxConcurrentReplays());
        }

        void conclude() {
            if (null == this.errorHandler) {
                throw new IllegalStateException("Error handler must be externally supplied");
            }
            if (null == this.countersManager) {
                throw new IllegalStateException("Counter manager must be externally supplied");
            }
            this.errorCounter = this.countersManager.newCounter("Archive errors");
            this.countedErrorHandler = new CountedErrorHandler(this.errorHandler, this.errorCounter);
            if (null == this.archiveDir) {
                this.archiveDir = new File(Configuration.archiveDirName());
            }
            if (!this.archiveDir.exists() && !this.archiveDir.mkdirs()) {
                throw new IllegalArgumentException("Failed to create archive dir: " + this.archiveDir.getAbsolutePath());
            }
            if (null == this.idleStrategySupplier) {
                this.idleStrategySupplier = Configuration.idleStrategySupplier(null);
            }
            if (null == this.epochClock) {
                this.epochClock = new SystemEpochClock();
            }
        }

        public File archiveDir() {
            return this.archiveDir;
        }

        public Context archiveDir(File archiveDir) {
            this.archiveDir = archiveDir;
            return this;
        }

        public Aeron.Context aeronContext() {
            return this.aeronContext;
        }

        public String controlChannel() {
            return this.controlChannel;
        }

        public Context controlChannel(String controlChannel) {
            this.controlChannel = controlChannel;
            return this;
        }

        public int controlStreamId() {
            return this.controlStreamId;
        }

        public Context controlStreamId(int controlStreamId) {
            this.controlStreamId = controlStreamId;
            return this;
        }

        public String recordingEventsChannel() {
            return this.recordingEventsChannel;
        }

        public Context recordingEventsChannel(String recordingEventsChannel) {
            this.recordingEventsChannel = recordingEventsChannel;
            return this;
        }

        public int recordingEventsStreamId() {
            return this.recordingEventsStreamId;
        }

        public Context recordingEventsStreamId(int recordingEventsStreamId) {
            this.recordingEventsStreamId = recordingEventsStreamId;
            return this;
        }

        public Context idleStrategySupplier(Supplier<IdleStrategy> idleStrategySupplier) {
            this.idleStrategySupplier = idleStrategySupplier;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategySupplier.get();
        }

        public Context epochClock(EpochClock clock) {
            this.epochClock = clock;
            return this;
        }

        public EpochClock epochClock() {
            return this.epochClock;
        }

        int segmentFileLength() {
            return this.segmentFileLength;
        }

        public Context segmentFileLength(int segmentFileLength) {
            this.segmentFileLength = segmentFileLength;
            return this;
        }

        int fileSyncLevel() {
            return this.fileSyncLevel;
        }

        public Context fileSyncLevel(int syncLevel) {
            this.fileSyncLevel = syncLevel;
            return this;
        }

        AgentInvoker mediaDriverAgentInvoker() {
            return this.mediaDriverAgentInvoker;
        }

        public Context mediaDriverAgentInvoker(AgentInvoker mediaDriverAgentInvoker) {
            this.mediaDriverAgentInvoker = mediaDriverAgentInvoker;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public CountedErrorHandler countedErrorHandler() {
            return this.countedErrorHandler;
        }

        public ArchiveThreadingMode threadingMode() {
            return this.threadingMode;
        }

        public Context threadingMode(ArchiveThreadingMode threadingMode) {
            this.threadingMode = threadingMode;
            return this;
        }

        public ThreadFactory threadFactory() {
            return this.threadFactory;
        }

        public Context threadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public AtomicCounter errorCounter() {
            return this.errorCounter;
        }

        public int maxConcurrentRecordings() {
            return this.maxConcurrentRecordings;
        }

        public Context maxConcurrentRecordings(int maxConcurrentRecordings) {
            this.maxConcurrentRecordings = maxConcurrentRecordings;
            return this;
        }

        public int maxConcurrentReplays() {
            return this.maxConcurrentReplays;
        }

        public Context maxConcurrentReplays(int maxConcurrentReplays) {
            this.maxConcurrentReplays = maxConcurrentReplays;
            return this;
        }

        public CountersManager countersManager() {
            return this.countersManager;
        }

        public Context countersManager(CountersManager countersManager) {
            this.countersManager = countersManager;
            return this;
        }

        public void deleteArchiveDirectory() {
            if (null != this.archiveDir) {
                IoUtil.delete(this.archiveDir, false);
            }
        }
    }

    public static class Configuration {
        public static final int ARCHIVE_RECORDING_POSITION_TYPE_ID = 100;
        public static final String ARCHIVE_DIR_PROP_NAME = "aeron.archive.dir";
        public static final String ARCHIVE_DIR_DEFAULT = "archive";
        static final String CATALOG_FILE_NAME = "archive.catalog";
        static final String RECORDING_SEGMENT_POSTFIX = ".rec";
        public static final String SEGMENT_FILE_LENGTH_PROP_NAME = "aeron.archive.segment.file.length";
        public static final int SEGMENT_FILE_LENGTH_DEFAULT = 0x8000000;
        public static final String FILE_SYNC_LEVEL_PROP_NAME = "aeron.archive.file.sync.level";
        public static final int FILE_SYNC_LEVEL_DEFAULT = 0;
        public static final String THREADING_MODE_PROP_NAME = "aeron.archive.threading.mode";
        public static final String ARCHIVER_IDLE_STRATEGY_PROP_NAME = "aeron.archive.idle.strategy";
        public static final String DEFAULT_IDLE_STRATEGY = "org.agrona.concurrent.BackoffIdleStrategy";
        static final long AGENT_IDLE_MAX_SPINS = 100L;
        static final long AGENT_IDLE_MAX_YIELDS = 100L;
        static final long AGENT_IDLE_MIN_PARK_NS = 1L;
        static final long AGENT_IDLE_MAX_PARK_NS = TimeUnit.MICROSECONDS.toNanos(1000L);
        public static final String MAX_CONCURRENT_RECORDINGS_PROP_NAME = "aeron.archive.max.concurrent.recordings";
        public static final int MAX_CONCURRENT_RECORDINGS_DEFAULT = 128;
        public static final String MAX_CONCURRENT_REPLAYS_PROP_NAME = "aeron.archive.max.concurrent.replays";
        public static final int MAX_CONCURRENT_REPLAYS_DEFAULT = 128;
        public static final String REPLAY_FRAGMENT_LIMIT_PROP_NAME = "aeron.archive.replay.fragment.limit";
        public static final int REPLAY_FRAGMENT_LIMIT_DEFAULT = 16;
        private static final String CONTROLLABLE_IDLE_STRATEGY = "org.agrona.concurrent.ControllableIdleStrategy";

        public static String archiveDirName() {
            return System.getProperty(ARCHIVE_DIR_PROP_NAME, ARCHIVE_DIR_DEFAULT);
        }

        public static int segmentFileLength() {
            return Integer.getInteger(SEGMENT_FILE_LENGTH_PROP_NAME, 0x8000000);
        }

        public static int fileSyncLevel() {
            return Integer.getInteger(FILE_SYNC_LEVEL_PROP_NAME, 0);
        }

        public static ArchiveThreadingMode threadingMode() {
            return ArchiveThreadingMode.valueOf(System.getProperty(THREADING_MODE_PROP_NAME, ArchiveThreadingMode.DEDICATED.name()));
        }

        public static Supplier<IdleStrategy> idleStrategySupplier(StatusIndicator controllableStatus) {
            String strategyName = System.getProperty(ARCHIVER_IDLE_STRATEGY_PROP_NAME, DEFAULT_IDLE_STRATEGY);
            return () -> {
                IdleStrategy idleStrategy = null;
                switch (strategyName) {
                    case "org.agrona.concurrent.BackoffIdleStrategy": {
                        idleStrategy = new BackoffIdleStrategy(100L, 100L, 1L, AGENT_IDLE_MAX_PARK_NS);
                        break;
                    }
                    case "org.agrona.concurrent.ControllableIdleStrategy": {
                        idleStrategy = new ControllableIdleStrategy(controllableStatus);
                        controllableStatus.setOrdered(4L);
                        break;
                    }
                    default: {
                        try {
                            idleStrategy = (IdleStrategy)Class.forName(strategyName).newInstance();
                            break;
                        }
                        catch (Exception ex) {
                            LangUtil.rethrowUnchecked(ex);
                        }
                    }
                }
                return idleStrategy;
            };
        }

        public static int maxConcurrentRecordings() {
            return Integer.getInteger(MAX_CONCURRENT_RECORDINGS_PROP_NAME, 128);
        }

        public static int maxConcurrentReplays() {
            return Integer.getInteger(MAX_CONCURRENT_REPLAYS_PROP_NAME, 128);
        }

        public static int replayFragmentLimit() {
            return Integer.getInteger(REPLAY_FRAGMENT_LIMIT_PROP_NAME, 16);
        }
    }
}

