/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.Catalog;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderDecoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderEncoder;
import io.aeron.protocol.DataHeaderFlyweight;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.agrona.BitUtil;
import org.agrona.BufferUtil;

public class CatalogTool {
    private static final ByteBuffer TEMP_BUFFER = BufferUtil.allocateDirectAligned(4096, 32);
    private static final DataHeaderFlyweight HEADER_FLYWEIGHT = new DataHeaderFlyweight(TEMP_BUFFER);
    private static File archiveDir;

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 3) {
            CatalogTool.printHelp();
            System.exit(-1);
        }
        if (!(archiveDir = new File(args[0])).exists()) {
            System.err.println("ERR: Archive folder not found: " + archiveDir.getAbsolutePath());
            CatalogTool.printHelp();
            System.exit(-1);
        }
        if (args.length == 2 && args[1].equals("describe")) {
            try (Catalog catalog = CatalogTool.openCatalog();){
                catalog.forEach((he, hd, e, d) -> System.out.println(d));
            }
        }
        if (args.length == 3 && args[1].equals("describe")) {
            try (Catalog catalog = CatalogTool.openCatalog();){
                catalog.forEntry((he, hd, e, d) -> System.out.println(d), Long.valueOf(args[2]));
            }
        }
        if (args.length == 2 && args[1].equals("verify")) {
            try (Catalog catalog = CatalogTool.openCatalog();){
                catalog.forEach(CatalogTool::verify);
            }
        }
        if (args.length == 3 && args[1].equals("verify")) {
            try (Catalog catalog = CatalogTool.openCatalog();){
                catalog.forEntry(CatalogTool::verify, Long.valueOf(args[2]));
            }
        }
    }

    private static Catalog openCatalog() {
        return new Catalog(archiveDir, null, 0, System::currentTimeMillis, false);
    }

    private static void verify(RecordingDescriptorHeaderEncoder headerEncoder, RecordingDescriptorHeaderDecoder headerDecoder, RecordingDescriptorEncoder encoder, RecordingDescriptorDecoder decoder) {
        long recordingId = decoder.recordingId();
        int segmentFileLength = decoder.segmentFileLength();
        int termBufferLength = decoder.termBufferLength();
        long startPosition = decoder.startPosition();
        long stopPosition = decoder.stopPosition();
        long recordingLength = stopPosition - startPosition;
        long startSegmentOffset = startPosition & (long)(termBufferLength - 1);
        long dataLength = startSegmentOffset + recordingLength;
        long endSegmentOffset = dataLength & (long)(segmentFileLength - 1);
        int recordingFileCount = (int)((dataLength + (long)segmentFileLength - 1L) / (long)segmentFileLength);
        String prefix = recordingId + ".";
        boolean[] filesFound = new boolean[recordingFileCount];
        for (String fileName : archiveDir.list((dir, name) -> name.startsWith(prefix))) {
            try {
                int index = Integer.valueOf(fileName.substring(prefix.length(), fileName.length() - ".rec".length()));
                filesFound[index] = true;
            }
            catch (Exception ex) {
                System.err.println("(recordingId=" + recordingId + ") ERR: malformed recording filename:" + fileName);
                ex.printStackTrace(System.err);
                headerEncoder.valid((byte)0);
                return;
            }
        }
        for (int i = 0; i < filesFound.length; ++i) {
            if (filesFound[i]) continue;
            System.err.println("(recordingId=" + recordingId + ") ERR: missing recording file :" + i);
            headerEncoder.valid((byte)0);
            return;
        }
        if (CatalogTool.verifyFirstFile(recordingId, decoder, startSegmentOffset)) {
            headerEncoder.valid((byte)0);
            return;
        }
        if (CatalogTool.verifyLastFile(recordingId, recordingFileCount, endSegmentOffset)) {
            headerEncoder.valid((byte)0);
            return;
        }
        headerEncoder.valid((byte)1);
        System.out.println("(recordingId=" + recordingId + ") OK");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verifyLastFile(long recordingId, int recordingFileCount, long endSegmentOffset) {
        File lastSegmentFile = new File(archiveDir, Archive.segmentFileName(recordingId, recordingFileCount - 1));
        try (FileChannel lastFile = FileChannel.open(lastSegmentFile.toPath(), StandardOpenOption.READ);){
            TEMP_BUFFER.clear();
            long position = 0L;
            do {
                TEMP_BUFFER.clear().limit(32);
                if (lastFile.read(TEMP_BUFFER, position) != 32) {
                    System.err.println("(recordingId=" + recordingId + ") ERR: failed to read fragment header.");
                    boolean bl = true;
                    return bl;
                }
                position += (long)BitUtil.align(HEADER_FLYWEIGHT.frameLength(), 32);
            } while (HEADER_FLYWEIGHT.frameLength() != 0);
            if (position == endSegmentOffset) return false;
            System.err.println("(recordingId=" + recordingId + ") ERR: end segment offset=" + position + " (expected=" + endSegmentOffset + ")");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            System.err.println("(recordingId=" + recordingId + ") ERR: failed to verify file:" + Archive.segmentFileName(recordingId, recordingFileCount - 1));
            ex.printStackTrace(System.err);
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean verifyFirstFile(long recordingId, RecordingDescriptorDecoder decoder, long joinSegmentOffset) {
        File firstSegmentFile = new File(archiveDir, Archive.segmentFileName(recordingId, 0));
        try (FileChannel firstFile = FileChannel.open(firstSegmentFile.toPath(), StandardOpenOption.READ);){
            TEMP_BUFFER.clear();
            TEMP_BUFFER.limit(32);
            if (firstFile.read(TEMP_BUFFER, joinSegmentOffset) != 32) {
                System.err.println("(recordingId=" + recordingId + ") ERR: missing reading first fragment header.");
                boolean bl = true;
                return bl;
            }
            if (HEADER_FLYWEIGHT.sessionId() != decoder.sessionId()) {
                System.err.println("(recordingId=" + recordingId + ") ERR: first fragment sessionId=" + HEADER_FLYWEIGHT.sessionId() + " (expected=" + decoder.sessionId() + ")");
                boolean bl = true;
                return bl;
            }
            if (HEADER_FLYWEIGHT.streamId() != decoder.streamId()) {
                System.err.println("(recordingId=" + recordingId + ") ERR: first fragment sessionId=" + HEADER_FLYWEIGHT.streamId() + " (expected=" + decoder.streamId() + ")");
                boolean bl = true;
                return bl;
            }
            int joinTermOffset = (int)joinSegmentOffset;
            if (HEADER_FLYWEIGHT.termOffset() != joinTermOffset) {
                System.err.println("(recordingId=" + recordingId + ") ERR: first fragment termOffset=" + HEADER_FLYWEIGHT.termOffset() + " (expected=" + joinTermOffset + ")");
                boolean bl = true;
                return bl;
            }
            long joinTermId = (long)decoder.initialTermId() + decoder.startPosition() / (long)decoder.termBufferLength();
            if ((long)HEADER_FLYWEIGHT.termId() == joinTermId) return false;
            System.err.println("(recordingId=" + recordingId + ") ERR: first fragment termId=" + HEADER_FLYWEIGHT.termId() + " (expected=" + joinTermId + ")");
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
            System.err.println("(recordingId=" + recordingId + ") ERR: fail to verify file:" + Archive.segmentFileName(recordingId, 0));
            ex.printStackTrace(System.err);
            return true;
        }
    }

    private static void printHelp() {
        System.out.println("Usage: <archive-dir> <command> <optional recordingId>");
        System.out.println("  describe: prints out all descriptors in the file. Optionally specify a recording id to describe a single recording.");
        System.out.println("  verify: verifies all descriptors in the file, checking recording files availability %nand contents. Faulty entries are marked as unusable. Optionally specify a recording id%nto verify a single recording.");
    }
}

