/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.archive.Archive;
import io.aeron.archive.ArchiveConductor;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.DedicatedModeSessionWorker;
import io.aeron.archive.RecordingSession;
import io.aeron.archive.ReplaySession;
import io.aeron.archive.Session;
import io.aeron.archive.SessionWorker;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.AgentRunner;
import org.agrona.concurrent.ManyToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

final class DedicatedModeArchiveConductor
extends ArchiveConductor {
    private static final int COMMAND_LIMIT = 10;
    private final ManyToOneConcurrentArrayQueue<Session> closeQueue;
    private AgentRunner replayerAgentRunner;
    private AgentRunner recorderAgentRunner;

    DedicatedModeArchiveConductor(Aeron aeron, Archive.Context ctx) {
        super(aeron, ctx);
        this.closeQueue = new ManyToOneConcurrentArrayQueue(ctx.maxConcurrentRecordings() + ctx.maxConcurrentReplays());
    }

    @Override
    public void onStart() {
        super.onStart();
        this.recorderAgentRunner = new AgentRunner(this.ctx.idleStrategy(), this.errorHandler, this.ctx.errorCounter(), this.recorder);
        this.replayerAgentRunner = new AgentRunner(this.ctx.idleStrategy(), this.errorHandler, this.ctx.errorCounter(), this.replayer);
        AgentRunner.startOnThread(this.replayerAgentRunner, this.ctx.threadFactory());
        AgentRunner.startOnThread(this.recorderAgentRunner, this.ctx.threadFactory());
    }

    @Override
    protected SessionWorker<RecordingSession> newRecorder() {
        return new DedicatedModeRecorder(this.errorHandler, this.ctx.errorCounter(), this.closeQueue);
    }

    @Override
    protected SessionWorker<ReplaySession> newReplayer() {
        return new DedicatedModeReplayer(this.errorHandler, this.ctx.errorCounter(), this.closeQueue, new ControlResponseProxy());
    }

    @Override
    protected int preWork() {
        return super.preWork() + this.processCloseQueue();
    }

    @Override
    protected void closeSessionWorkers() {
        try {
            CloseHelper.close(this.recorderAgentRunner);
        }
        catch (Exception ex) {
            this.errorHandler.onError(ex);
        }
        try {
            CloseHelper.close(this.replayerAgentRunner);
        }
        catch (Exception ex) {
            this.errorHandler.onError(ex);
        }
        while (this.processCloseQueue() > 0 || !this.closeQueue.isEmpty()) {
        }
    }

    @Override
    protected void postSessionsClose() {
        if (!this.closeQueue.isEmpty()) {
            System.err.println("ERR: Close queue not empty");
        }
        super.postSessionsClose();
    }

    private int processCloseQueue() {
        Session session;
        int i;
        for (i = 0; i < 10 && (session = this.closeQueue.poll()) != null; ++i) {
            if (session instanceof RecordingSession) {
                this.closeRecordingSession((RecordingSession)session);
                continue;
            }
            if (session instanceof ReplaySession) {
                ReplaySession replaySession = (ReplaySession)session;
                replaySession.setThreadLocalControlResponseProxy(this.controlResponseProxy);
                this.closeReplaySession(replaySession);
                continue;
            }
            this.closeSession(session);
        }
        return i;
    }

    static class DedicatedModeReplayer
    extends DedicatedModeSessionWorker<ReplaySession> {
        private final ManyToOneConcurrentArrayQueue<Session> closeQueue;
        private final ControlResponseProxy proxy;

        DedicatedModeReplayer(ErrorHandler errorHandler, AtomicCounter errorCounter, ManyToOneConcurrentArrayQueue<Session> closeQueue, ControlResponseProxy proxy) {
            super("archive-replayer", errorHandler, errorCounter);
            this.closeQueue = closeQueue;
            this.proxy = proxy;
        }

        @Override
        protected void postSessionAdd(ReplaySession session) {
            session.setThreadLocalControlResponseProxy(this.proxy);
        }

        @Override
        protected void closeSession(ReplaySession session) {
            this.closeQueue.offer(session);
        }
    }

    static class DedicatedModeRecorder
    extends DedicatedModeSessionWorker<RecordingSession> {
        private final ManyToOneConcurrentArrayQueue<Session> closeQueue;

        DedicatedModeRecorder(ErrorHandler errorHandler, AtomicCounter errorCounter, ManyToOneConcurrentArrayQueue<Session> closeQueue) {
            super("archive-recorder", errorHandler, errorCounter);
            this.closeQueue = closeQueue;
        }

        @Override
        protected void closeSession(RecordingSession session) {
            this.closeQueue.offer(session);
        }
    }
}

