/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Session;
import io.aeron.archive.SessionWorker;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.OneToOneConcurrentArrayQueue;
import org.agrona.concurrent.status.AtomicCounter;

class DedicatedModeSessionWorker<T extends Session>
extends SessionWorker<T> {
    private final OneToOneConcurrentArrayQueue<Runnable> commandQueue = new OneToOneConcurrentArrayQueue(256);
    private final AtomicCounter errorCounter;

    DedicatedModeSessionWorker(String roleName, ErrorHandler errorHandler, AtomicCounter errorCounter) {
        super(roleName, errorHandler);
        this.errorCounter = errorCounter;
    }

    @Override
    protected int preWork() {
        return this.commandQueue.drain(Runnable::run);
    }

    @Override
    protected void addSession(T session) {
        this.send(() -> super.addSession(session));
    }

    @Override
    protected void preSessionsClose() {
        this.commandQueue.drain(Runnable::run);
    }

    private void send(Runnable r) {
        while (!this.commandQueue.offer(r)) {
            this.errorCounter.increment();
            Thread.yield();
        }
    }
}

