/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.AbstractListRecordingsSession;
import io.aeron.archive.Catalog;
import io.aeron.archive.ControlResponseProxy;
import io.aeron.archive.ControlSession;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import org.agrona.concurrent.UnsafeBuffer;

class ListRecordingsForUriSession
extends AbstractListRecordingsSession {
    private static final int MAX_SCANS_PER_WORK_CYCLE = 16;
    private final RecordingDescriptorDecoder decoder;
    private final int count;
    private final String channel;
    private final int streamId;
    private int sent = 0;
    private long recordingId;

    ListRecordingsForUriSession(long correlationId, long fromRecordingId, int count, String channel, int streamId, Catalog catalog, ControlResponseProxy proxy, ControlSession controlSession, UnsafeBuffer descriptorBuffer, RecordingDescriptorDecoder recordingDescriptorDecoder) {
        super(correlationId, catalog, proxy, controlSession, descriptorBuffer);
        this.recordingId = fromRecordingId;
        this.count = count;
        this.channel = channel;
        this.streamId = streamId;
        this.decoder = recordingDescriptorDecoder;
    }

    @Override
    protected int sendDescriptors() {
        int totalBytesSent = 0;
        for (int recordsScanned = 0; this.sent < this.count && totalBytesSent < this.controlSession.maxPayloadLength() && recordsScanned < 16; ++recordsScanned) {
            if (!this.catalog.wrapDescriptor(this.recordingId, this.descriptorBuffer)) {
                this.controlSession.sendRecordingUnknown(this.correlationId, this.recordingId, this.proxy);
                this.isDone = true;
                break;
            }
            Catalog.wrapDescriptorDecoder(this.decoder, this.descriptorBuffer);
            if (this.decoder.streamId() == this.streamId && this.decoder.strippedChannel().equals(this.channel) && this.isDescriptorValid(this.descriptorBuffer)) {
                int bytesSent = this.controlSession.sendDescriptor(this.correlationId, this.descriptorBuffer, this.proxy);
                if (bytesSent == 0) {
                    this.isDone = this.controlSession.isDone();
                    break;
                }
                totalBytesSent += bytesSent;
                ++this.sent;
            }
            ++this.recordingId;
        }
        if (this.sent >= this.count) {
            this.isDone = true;
        }
        return totalBytesSent;
    }
}

