/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.archive.Archive;
import io.aeron.archive.RecordingEventsProxy;
import io.aeron.archive.RecordingWriter;
import io.aeron.archive.Session;
import java.nio.channels.FileChannel;
import org.agrona.CloseHelper;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class RecordingSession
implements Session {
    private static final int MAX_BLOCK_LENGTH = 19726336;
    private final long recordingId;
    private final int blockLengthLimit;
    private final UnsafeBuffer descriptorBuffer;
    private final RecordingEventsProxy recordingEventsProxy;
    private final String strippedChannel;
    private final Image image;
    private final AtomicCounter position;
    private final FileChannel archiveDirChannel;
    private final Archive.Context context;
    private RecordingWriter recordingWriter;
    private State state = State.INIT;

    RecordingSession(long recordingId, UnsafeBuffer descriptorBuffer, RecordingEventsProxy recordingEventsProxy, String strippedChannel, Image image, AtomicCounter position, FileChannel archiveDirChannel, Archive.Context context) {
        this.recordingId = recordingId;
        this.descriptorBuffer = descriptorBuffer;
        this.recordingEventsProxy = recordingEventsProxy;
        this.strippedChannel = strippedChannel;
        this.image = image;
        this.position = position;
        this.archiveDirChannel = archiveDirChannel;
        this.context = context;
        this.blockLengthLimit = Math.min(image.termBufferLength(), 19726336);
    }

    @Override
    public boolean isDone() {
        return this.state == State.INACTIVE;
    }

    @Override
    public void abort() {
        this.state = State.INACTIVE;
        CloseHelper.quietClose(this.recordingWriter);
    }

    @Override
    public int doWork() {
        int workDone = 0;
        switch (this.state) {
            case INIT: {
                workDone += this.init();
                break;
            }
            case RECORDING: {
                workDone += this.record();
                break;
            }
            case INACTIVE: {
                this.recordingWriter.close();
            }
        }
        return workDone;
    }

    @Override
    public long sessionId() {
        return this.recordingId;
    }

    private int init() {
        Subscription subscription = this.image.subscription();
        int sessionId = this.image.sessionId();
        int streamId = subscription.streamId();
        String sourceIdentity = this.image.sourceIdentity();
        long startPosition = this.image.joinPosition();
        RecordingWriter recordingWriter = null;
        try {
            recordingWriter = new RecordingWriter(this.context, this.archiveDirChannel, this.descriptorBuffer, this.position);
        }
        catch (Exception ex) {
            this.state = State.INACTIVE;
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
        this.recordingEventsProxy.started(this.recordingId, startPosition, sessionId, streamId, this.strippedChannel, sourceIdentity);
        this.recordingWriter = recordingWriter;
        this.state = State.RECORDING;
        return 1;
    }

    @Override
    public void close() {
        this.state = State.CLOSED;
        if (this.recordingWriter != null) {
            long startPosition = this.recordingWriter.startPosition();
            long stopPosition = this.recordingWriter.recordedPosition();
            CloseHelper.quietClose(this.recordingWriter);
            this.recordingEventsProxy.stopped(this.recordingId, startPosition, stopPosition);
        } else {
            this.recordingEventsProxy.stopped(this.recordingId, -1L, -1L);
        }
    }

    UnsafeBuffer descriptorBuffer() {
        return this.descriptorBuffer;
    }

    private int record() {
        int workCount = 1;
        try {
            workCount = this.image.rawPoll(this.recordingWriter, this.blockLengthLimit);
            if (workCount != 0) {
                this.recordingEventsProxy.progress(this.recordingWriter.recordingId(), this.recordingWriter.startPosition(), this.recordingWriter.recordedPosition());
            }
            if (this.image.isClosed() || this.recordingWriter.isClosed()) {
                this.abort();
            }
        }
        catch (Exception ex) {
            this.abort();
            LangUtil.rethrowUnchecked(ex);
        }
        return workCount;
    }

    private static enum State {
        INIT,
        RECORDING,
        INACTIVE,
        CLOSED;

    }
}

