/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.archive.Archive;
import io.aeron.archive.Catalog;
import io.aeron.archive.codecs.RecordingDescriptorDecoder;
import io.aeron.logbuffer.Header;
import io.aeron.logbuffer.RawBlockHandler;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;

class RecordingWriter
implements AutoCloseable,
RawBlockHandler {
    private static final int NULL_SEGMENT_POSITION = -1;
    private final boolean forceWrites;
    private final boolean forceMetadata;
    private final long recordingId;
    private final FileChannel archiveDirChannel;
    private final File archiveDir;
    private final AtomicCounter recordedPosition;
    private final int segmentFileLength;
    private final long startPosition;
    private int segmentPosition = -1;
    private int segmentIndex = 0;
    private FileChannel recordingFileChannel;
    private boolean isClosed = false;

    RecordingWriter(Archive.Context context, FileChannel archiveDirChannel, UnsafeBuffer descriptorBuffer, AtomicCounter recordedPosition) {
        this.recordedPosition = recordedPosition;
        RecordingDescriptorDecoder descriptorDecoder = new RecordingDescriptorDecoder();
        Catalog.wrapDescriptorDecoder(descriptorDecoder, descriptorBuffer);
        int termBufferLength = descriptorDecoder.termBufferLength();
        this.archiveDirChannel = archiveDirChannel;
        this.archiveDir = context.archiveDir();
        this.segmentFileLength = Math.max(context.segmentFileLength(), termBufferLength);
        this.forceWrites = context.fileSyncLevel() > 0;
        this.forceMetadata = context.fileSyncLevel() > 1;
        this.recordingId = descriptorDecoder.recordingId();
        this.startPosition = descriptorDecoder.startPosition();
        recordedPosition.setOrdered(this.startPosition);
        int termsMask = this.segmentFileLength / termBufferLength - 1;
        if ((termsMask + 1 & termsMask) != 0) {
            throw new IllegalArgumentException("It is assumed the termBufferLength is a power of 2, and that the number of termsin a file is also a power of 2");
        }
    }

    @Override
    public void onBlock(FileChannel fileChannel, long fileOffset, UnsafeBuffer termBuffer, int termOffset, int blockLength, int sessionId, int termId) {
        try {
            if (-1L == (long)this.segmentPosition) {
                this.onFirstWrite(termOffset);
            }
            if (this.segmentFileLength == this.segmentPosition) {
                this.onFileRollOver();
            }
            long bytesWritten = 0L;
            while ((bytesWritten += this.transferTo(fileChannel, fileOffset + bytesWritten, (long)blockLength - bytesWritten)) < (long)blockLength) {
            }
            if (this.forceWrites) {
                this.forceData(this.recordingFileChannel, this.forceMetadata);
            }
            this.afterWrite(blockLength);
        }
        catch (ClosedByInterruptException ex) {
            Thread.interrupted();
            this.close();
            throw new IllegalStateException("Image file channel has been closed by interrupt, recording aborted.", ex);
        }
        catch (Exception ex) {
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        CloseHelper.close(this.recordingFileChannel);
    }

    void writeFragment(DirectBuffer buffer, Header header) {
        int termOffset = header.termOffset();
        int frameLength = header.frameLength();
        int alignedLength = BitUtil.align(frameLength, 32);
        try {
            if (-1L == (long)this.segmentPosition) {
                this.onFirstWrite(termOffset);
            }
            if (this.segmentFileLength == this.segmentPosition) {
                this.onFileRollOver();
            }
            ByteBuffer src = buffer.byteBuffer().duplicate();
            src.position(termOffset).limit(termOffset + frameLength);
            int written = this.writeData(src, this.segmentPosition, this.recordingFileChannel);
            this.recordingFileChannel.position(this.segmentPosition + alignedLength);
            if (written != frameLength) {
                throw new IllegalStateException();
            }
            if (this.forceWrites) {
                this.forceData(this.recordingFileChannel, this.forceMetadata);
            }
            this.afterWrite(alignedLength);
        }
        catch (Exception ex) {
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
    }

    long recordingId() {
        return this.recordingId;
    }

    int segmentFileLength() {
        return this.segmentFileLength;
    }

    long startPosition() {
        return this.startPosition;
    }

    long recordedPosition() {
        return this.recordedPosition.getWeak();
    }

    private int writeData(ByteBuffer buffer, int position, FileChannel fileChannel) throws IOException {
        return fileChannel.write(buffer, position);
    }

    long transferTo(FileChannel fromFileChannel, long position, long count) throws IOException {
        return fromFileChannel.transferTo(position, count, this.recordingFileChannel);
    }

    void newRecordingSegmentFile() {
        File file = new File(this.archiveDir, Archive.segmentFileName(this.recordingId, this.segmentIndex));
        RandomAccessFile recordingFile = null;
        try {
            recordingFile = new RandomAccessFile(file, "rw");
            recordingFile.setLength(this.segmentFileLength + 32);
            this.recordingFileChannel = recordingFile.getChannel();
            if (this.forceWrites && null != this.archiveDirChannel) {
                this.forceData(this.archiveDirChannel, this.forceMetadata);
            }
        }
        catch (IOException ex) {
            CloseHelper.quietClose(recordingFile);
            this.close();
            LangUtil.rethrowUnchecked(ex);
        }
    }

    void forceData(FileChannel fileChannel, boolean forceMetadata) throws IOException {
        fileChannel.force(forceMetadata);
    }

    boolean isClosed() {
        return this.isClosed;
    }

    private void onFileRollOver() {
        CloseHelper.close(this.recordingFileChannel);
        this.segmentPosition = 0;
        ++this.segmentIndex;
        this.newRecordingSegmentFile();
    }

    private void onFirstWrite(int termOffset) throws IOException {
        this.segmentPosition = termOffset;
        this.newRecordingSegmentFile();
        if (this.segmentPosition != 0) {
            this.recordingFileChannel.position(this.segmentPosition);
        }
    }

    private void afterWrite(int blockLength) {
        this.segmentPosition += blockLength;
        this.recordedPosition.addOrdered(blockLength);
    }
}

