/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Aeron;
import io.aeron.AvailableImageHandler;
import io.aeron.ChannelUri;
import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.archive.client.ArchiveProxy;
import io.aeron.archive.client.ControlResponseAdapter;
import io.aeron.archive.client.ControlResponsePoller;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.exceptions.TimeoutException;
import java.util.concurrent.TimeUnit;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;

public final class AeronArchive
implements AutoCloseable {
    private static final int RESPONSE_FRAGMENT_LIMIT = 4;
    private final long messageTimeoutNs;
    private final Context context;
    private final Aeron aeron;
    private final ArchiveProxy archiveProxy;
    private final IdleStrategy idleStrategy;
    private final ControlResponsePoller controlResponsePoller;
    private final long controlSessionId;

    private AeronArchive(Context context) {
        try {
            context.conclude();
            this.context = context;
            this.aeron = context.aeron();
            this.idleStrategy = context.idleStrategy();
            this.messageTimeoutNs = context.messageTimeoutNs();
            this.archiveProxy = context.archiveProxy();
            long correlationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.connect(context.controlResponseChannel(), context.controlResponseStreamId(), correlationId)) {
                throw new IllegalStateException("Cannot connect to aeron archive: " + context.controlRequestChannel());
            }
            this.controlResponsePoller = new ControlResponsePoller(this.aeron.addSubscription(context.controlResponseChannel(), context.controlResponseStreamId()), 4);
            this.controlSessionId = this.pollForConnected(correlationId);
        }
        catch (Exception ex) {
            context.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        this.archiveProxy.closeSession(this.controlSessionId);
        if (!this.context.ownsAeronClient()) {
            this.controlResponsePoller.subscription().close();
            this.archiveProxy.publication().close();
        }
        this.context.close();
    }

    public static AeronArchive connect() {
        return new AeronArchive(new Context());
    }

    public static AeronArchive connect(Context context) {
        return new AeronArchive(context);
    }

    public ArchiveProxy archiveProxy() {
        return this.archiveProxy;
    }

    public ControlResponsePoller controlResponsePoller() {
        return this.controlResponsePoller;
    }

    public String pollForErrorResponse() {
        if (this.controlResponsePoller.poll() != 0 && this.controlResponsePoller.isPollComplete() && this.controlResponsePoller.templateId() == 1 && this.controlResponsePoller.controlResponseDecoder().code() == ControlResponseCode.ERROR) {
            return this.controlResponsePoller.controlResponseDecoder().errorMessage();
        }
        return null;
    }

    public Publication addRecordedPublication(String channel, int streamId) {
        this.startRecording(channel, streamId, SourceLocation.LOCAL);
        Publication publication = this.aeron.addPublication(channel, streamId);
        if (!publication.isOriginal()) {
            publication.close();
            throw new IllegalStateException("Publication already added for channel=" + channel + " streamId=" + streamId);
        }
        return publication;
    }

    public ExclusivePublication addRecordedExclusivePublication(String channel, int streamId) {
        this.startRecording(channel, streamId, SourceLocation.LOCAL);
        return this.aeron.addExclusivePublication(channel, streamId);
    }

    public void startRecording(String channel, int streamId, SourceLocation sourceLocation) {
        long correlationId = this.aeron.nextCorrelationId();
        if (!this.archiveProxy.startRecording(channel, streamId, sourceLocation, correlationId, this.controlSessionId)) {
            throw new IllegalStateException("Failed to send start recording request");
        }
        this.pollForResponse(correlationId);
    }

    public void stopRecording(String channel, int streamId) {
        long correlationId = this.aeron.nextCorrelationId();
        if (!this.archiveProxy.stopRecording(channel, streamId, correlationId, this.controlSessionId)) {
            throw new IllegalStateException("Failed to send stop recording request");
        }
        this.pollForResponse(correlationId);
    }

    public Subscription replay(long recordingId, long position, long length, String replayChannel, int replayStreamId) {
        long correlationId = this.aeron.nextCorrelationId();
        if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, correlationId, this.controlSessionId)) {
            throw new IllegalStateException("Failed to send replay request");
        }
        this.pollForResponse(correlationId);
        return this.aeron.addSubscription(replayChannel, replayStreamId);
    }

    public Subscription replay(long recordingId, long position, long length, String replayChannel, int replayStreamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        long correlationId = this.aeron.nextCorrelationId();
        if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, correlationId, this.controlSessionId)) {
            throw new IllegalStateException("Failed to send replay request");
        }
        this.pollForResponse(correlationId);
        return this.aeron.addSubscription(replayChannel, replayStreamId, availableImageHandler, unavailableImageHandler);
    }

    public int listRecordings(long fromRecordingId, int recordCount, RecordingDescriptorConsumer consumer) {
        long correlationId = this.aeron.nextCorrelationId();
        if (!this.archiveProxy.listRecordings(fromRecordingId, recordCount, correlationId, this.controlSessionId)) {
            throw new IllegalStateException("Failed to send list recordings request");
        }
        return this.pollForDescriptors(correlationId, recordCount, consumer);
    }

    public int listRecordingsForUri(long fromRecordingId, int recordCount, String channel, int streamId, RecordingDescriptorConsumer consumer) {
        long correlationId = this.aeron.nextCorrelationId();
        if (!this.archiveProxy.listRecordingsForUri(fromRecordingId, recordCount, channel, streamId, correlationId, this.controlSessionId)) {
            throw new IllegalStateException("Failed to send list recordings request");
        }
        return this.pollForDescriptors(correlationId, recordCount, consumer);
    }

    private long pollForConnected(long expectedCorrelationId) {
        long deadline = System.nanoTime() + this.messageTimeoutNs;
        ControlResponsePoller poller = this.controlResponsePoller;
        this.idleStrategy.reset();
        while (true) {
            if (poller.poll() <= 0 && !poller.isPollComplete()) {
                if (System.nanoTime() > deadline) {
                    throw new TimeoutException("Waiting for response: correlationId=" + expectedCorrelationId);
                }
                this.idleStrategy.idle();
                continue;
            }
            if (poller.correlationId() == expectedCorrelationId) break;
        }
        if (poller.templateId() != 1) {
            throw new IllegalStateException("Unknown response: templateId=" + poller.templateId());
        }
        ControlResponseCode code = poller.controlResponseDecoder().code();
        if (code != ControlResponseCode.CONNECTED) {
            throw new IllegalStateException("Unexpected response: code=" + (Object)((Object)code));
        }
        return poller.controlSessionId();
    }

    private void pollForResponse(long expectedCorrelationId) {
        long deadline = System.nanoTime() + this.messageTimeoutNs;
        ControlResponsePoller poller = this.controlResponsePoller;
        this.idleStrategy.reset();
        while (true) {
            if (poller.poll() <= 0 && !poller.isPollComplete()) {
                if (System.nanoTime() > deadline) {
                    throw new TimeoutException("Waiting for response: correlationId=" + expectedCorrelationId);
                }
                this.idleStrategy.idle();
                continue;
            }
            if (poller.controlSessionId() == this.controlSessionId && poller.correlationId() == expectedCorrelationId) break;
        }
        if (poller.templateId() == 1) {
            ControlResponseCode code = poller.controlResponseDecoder().code();
            switch (code) {
                case OK: {
                    return;
                }
                case ERROR: {
                    throw new IllegalStateException("response for correlationId=" + expectedCorrelationId + " error: " + poller.controlResponseDecoder().errorMessage());
                }
            }
            throw new IllegalStateException("Unexpected response code: " + (Object)((Object)code));
        }
        throw new IllegalStateException("Unknown response type: templateId=" + poller.templateId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int pollForDescriptors(long expectedCorrelationId, int recordCount, RecordingDescriptorConsumer consumer) {
        int count = 0;
        long deadline = System.nanoTime() + this.messageTimeoutNs;
        ControlResponsePoller poller = this.controlResponsePoller;
        this.idleStrategy.reset();
        block8: while (true) {
            if (poller.poll() <= 0 && !poller.isPollComplete()) {
                if (System.nanoTime() > deadline) {
                    throw new TimeoutException("Waiting for recording descriptors: correlationId=" + expectedCorrelationId);
                }
                this.idleStrategy.idle();
                continue;
            }
            if (poller.controlSessionId() != this.controlSessionId || poller.correlationId() != expectedCorrelationId) continue;
            switch (poller.templateId()) {
                case 11: {
                    ControlResponseAdapter.dispatchDescriptor(poller.recordingDescriptorDecoder(), consumer);
                    if (++count >= recordCount) return count;
                    continue block8;
                }
                case 1: {
                    ControlResponseCode code = poller.controlResponseDecoder().code();
                    switch (code) {
                        case RECORDING_UNKNOWN: {
                            return count;
                        }
                        case ERROR: {
                            throw new IllegalStateException("response for correlationId=" + expectedCorrelationId + " error: " + poller.controlResponseDecoder().errorMessage());
                        }
                    }
                    throw new IllegalStateException("Unexpected response: code=" + (Object)((Object)code));
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown response: templateId=" + poller.templateId());
    }

    public static class Context
    implements AutoCloseable {
        private long messageTimeoutNs = Configuration.messageTimeoutNs();
        private String controlRequestChannel = Configuration.controlChannel();
        private int controlRequestStreamId = Configuration.controlStreamId();
        private String controlResponseChannel = Configuration.controlResponseChannel();
        private int controlResponseStreamId = Configuration.controlResponseStreamId();
        private int controlTermBufferLength = Configuration.controlTermBufferLength();
        private int controlMtuLength = Configuration.controlMtuLength();
        private Aeron aeron;
        private ArchiveProxy archiveProxy;
        private IdleStrategy idleStrategy;
        private boolean ownsAeronClient = true;

        public void conclude() {
            if (null == this.aeron) {
                this.aeron = Aeron.connect();
            }
            if (null == this.idleStrategy) {
                this.idleStrategy = new BackoffIdleStrategy(1L, 10L, 1L, 1L);
            }
            ChannelUri controlChannel = ChannelUri.parse(this.controlRequestChannel);
            controlChannel.put("term-length", Integer.toString(this.controlTermBufferLength));
            controlChannel.put("mtu", Integer.toString(this.controlMtuLength));
            this.controlRequestChannel = controlChannel.toString();
            if (null == this.archiveProxy) {
                this.archiveProxy = new ArchiveProxy(this.aeron.addPublication(this.controlRequestChannel, this.controlRequestStreamId), this.idleStrategy, this.messageTimeoutNs, 3);
            }
        }

        public Context messageTimeoutNs(long messageTimeoutNs) {
            this.messageTimeoutNs = messageTimeoutNs;
            return this;
        }

        public long messageTimeoutNs() {
            return this.messageTimeoutNs;
        }

        public Context controlRequestChannel(String channel) {
            this.controlRequestChannel = channel;
            return this;
        }

        public String controlRequestChannel() {
            return this.controlRequestChannel;
        }

        public Context controlRequestStreamId(int streamId) {
            this.controlRequestStreamId = streamId;
            return this;
        }

        public int controlRequestStreamId() {
            return this.controlRequestStreamId;
        }

        public Context controlResponseChannel(String channel) {
            this.controlResponseChannel = channel;
            return this;
        }

        public String controlResponseChannel() {
            return this.controlResponseChannel;
        }

        public Context controlResponseStreamId(int streamId) {
            this.controlResponseStreamId = streamId;
            return this;
        }

        public int controlResponseStreamId() {
            return this.controlResponseStreamId;
        }

        public Context controlTermBufferLength(int controlTermBufferLength) {
            this.controlTermBufferLength = controlTermBufferLength;
            return this;
        }

        public int controlTermBufferLength() {
            return this.controlTermBufferLength;
        }

        public Context controlMtuLength(int controlMtuLength) {
            this.controlMtuLength = controlMtuLength;
            return this;
        }

        public int controlMtuLength() {
            return this.controlMtuLength;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context archiveProxy(ArchiveProxy archiveProxy) {
            this.archiveProxy = archiveProxy;
            return this;
        }

        public ArchiveProxy archiveProxy() {
            return this.archiveProxy;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        @Override
        public void close() {
            if (this.ownsAeronClient) {
                this.aeron.close();
            }
        }
    }

    public static class Configuration {
        public static final String MESSAGE_TIMEOUT_PROP_NAME = "aeron.archive.message.timeout";
        public static final long MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(5L);
        public static final String CONTROL_CHANNEL_PROP_NAME = "aeron.archive.control.channel";
        public static final String CONTROL_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:8010";
        public static final String CONTROL_STREAM_ID_PROP_NAME = "aeron.archive.control.stream.id";
        public static final int CONTROL_STREAM_ID_DEFAULT = 0;
        public static final String CONTROL_RESPONSE_CHANNEL_PROP_NAME = "aeron.archive.control.response.channel";
        public static final String CONTROL_RESPONSE_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:8020";
        public static final String CONTROL_RESPONSE_STREAM_ID_PROP_NAME = "aeron.archive.control.response.stream.id";
        public static final int CONTROL_RESPONSE_STREAM_ID_DEFAULT = 0;
        public static final String RECORDING_EVENTS_CHANNEL_PROP_NAME = "aeron.archive.recording.events.channel";
        public static final String RECORDING_EVENTS_CHANNEL_DEFAULT = "aeron:udp?endpoint=localhost:8011";
        public static final String RECORDING_EVENTS_STREAM_ID_PROP_NAME = "aeron.archive.recording.events.stream.id";
        public static final int RECORDING_EVENTS_STREAM_ID_DEFAULT = 0;
        private static final String CONTROL_TERM_BUFFER_LENGTH_PARAM_NAME = "aeron.archive.control.term.buffer.length";
        private static final int CONTROL_TERM_BUFFER_LENGTH_DEFAULT = 65536;
        private static final String CONTROL_MTU_LENGTH_PARAM_NAME = "aeron.archive.control.mtu.length";
        private static final int CONTROL_MTU_LENGTH_DEFAULT = 4096;

        public static long messageTimeoutNs() {
            return Long.getLong(MESSAGE_TIMEOUT_PROP_NAME, MESSAGE_TIMEOUT_DEFAULT_NS);
        }

        public static int controlTermBufferLength() {
            return Integer.getInteger(CONTROL_TERM_BUFFER_LENGTH_PARAM_NAME, 65536);
        }

        public static int controlMtuLength() {
            return Integer.getInteger(CONTROL_MTU_LENGTH_PARAM_NAME, 4096);
        }

        public static String controlChannel() {
            return System.getProperty(CONTROL_CHANNEL_PROP_NAME, CONTROL_CHANNEL_DEFAULT);
        }

        public static int controlStreamId() {
            return Integer.getInteger(CONTROL_STREAM_ID_PROP_NAME, 0);
        }

        public static String controlResponseChannel() {
            return System.getProperty(CONTROL_RESPONSE_CHANNEL_PROP_NAME, CONTROL_RESPONSE_CHANNEL_DEFAULT);
        }

        public static int controlResponseStreamId() {
            return Integer.getInteger(CONTROL_RESPONSE_STREAM_ID_PROP_NAME, 0);
        }

        public static String recordingEventsChannel() {
            return System.getProperty(RECORDING_EVENTS_CHANNEL_PROP_NAME, RECORDING_EVENTS_CHANNEL_DEFAULT);
        }

        public static int recordingEventsStreamId() {
            return Integer.getInteger(RECORDING_EVENTS_STREAM_ID_PROP_NAME, 0);
        }
    }
}

