/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Subscription;
import io.aeron.archive.codecs.MessageHeaderDecoder;
import io.aeron.archive.codecs.RecordingProgressDecoder;
import io.aeron.archive.codecs.RecordingStartedDecoder;
import io.aeron.archive.codecs.RecordingStoppedDecoder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.DirectBuffer;

public class RecordingEventsPoller
implements FragmentHandler {
    private final MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
    private final RecordingStartedDecoder recordingStartedDecoder = new RecordingStartedDecoder();
    private final RecordingProgressDecoder recordingProgressDecoder = new RecordingProgressDecoder();
    private final RecordingStoppedDecoder recordingStoppedDecoder = new RecordingStoppedDecoder();
    private final Subscription subscription;
    private int templateId;
    private boolean pollComplete;

    public RecordingEventsPoller(Subscription subscription) {
        this.subscription = subscription;
    }

    public int poll() {
        this.templateId = -1;
        this.pollComplete = false;
        return this.subscription.poll(this, 1);
    }

    public boolean isPollComplete() {
        return this.pollComplete;
    }

    public int templateId() {
        return this.templateId;
    }

    @Override
    public void onFragment(DirectBuffer buffer, int offset, int length, Header header) {
        this.messageHeaderDecoder.wrap(buffer, offset);
        this.templateId = this.messageHeaderDecoder.templateId();
        switch (this.templateId) {
            case 101: {
                this.recordingStartedDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                break;
            }
            case 102: {
                this.recordingProgressDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                break;
            }
            case 103: {
                this.recordingStoppedDecoder.wrap(buffer, offset + 8, this.messageHeaderDecoder.blockLength(), this.messageHeaderDecoder.version());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown templateId: " + this.templateId);
            }
        }
        this.pollComplete = true;
    }

    public MessageHeaderDecoder messageHeaderDecoder() {
        return this.messageHeaderDecoder;
    }

    public RecordingStartedDecoder recordingStartedDecoder() {
        return this.recordingStartedDecoder;
    }

    public RecordingProgressDecoder recordingProgressDecoder() {
        return this.recordingProgressDecoder;
    }

    public RecordingStoppedDecoder recordingStoppedDecoder() {
        return this.recordingStoppedDecoder;
    }
}

