/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public class CloseSessionRequestDecoder {
    public static final int BLOCK_LENGTH = 8;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final CloseSessionRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    protected int offset;
    protected int limit;
    protected int actingBlockLength;
    protected int actingVersion;

    public int sbeBlockLength() {
        return 8;
    }

    public int sbeTemplateId() {
        return 3;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public CloseSessionRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        this.buffer = buffer;
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdId() {
        return 1;
    }

    public static int controlSessionIdSinceVersion() {
        return 0;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static String controlSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        switch (metaAttribute) {
            case EPOCH: {
                return "unix";
            }
            case TIME_UNIT: {
                return "nanosecond";
            }
            case SEMANTIC_TYPE: {
                return "";
            }
            case PRESENCE: {
                return "required";
            }
        }
        return "";
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long controlSessionId() {
        return this.buffer.getLong(this.offset + 0, ByteOrder.LITTLE_ENDIAN);
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[CloseSessionRequest](sbeTemplateId=");
        builder.append(3);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 8) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(8);
        builder.append("):");
        builder.append("controlSessionId=");
        builder.append(this.controlSessionId());
        this.limit(originalLimit);
        return builder;
    }
}

