/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.ListRecordingsRequestDecoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public class ListRecordingsRequestEncoder {
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 7;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final ListRecordingsRequestEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 28;
    }

    public int sbeTemplateId() {
        return 7;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ListRecordingsRequestEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 28);
        return this;
    }

    public ListRecordingsRequestEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(28).templateId(7).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int controlSessionIdEncodingOffset() {
        return 0;
    }

    public static int controlSessionIdEncodingLength() {
        return 8;
    }

    public static long controlSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long controlSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long controlSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ListRecordingsRequestEncoder controlSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int correlationIdEncodingOffset() {
        return 8;
    }

    public static int correlationIdEncodingLength() {
        return 8;
    }

    public static long correlationIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long correlationIdMinValue() {
        return -9223372036854775807L;
    }

    public static long correlationIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ListRecordingsRequestEncoder correlationId(long value) {
        this.buffer.putLong(this.offset + 8, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int fromRecordingIdEncodingOffset() {
        return 16;
    }

    public static int fromRecordingIdEncodingLength() {
        return 8;
    }

    public static long fromRecordingIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long fromRecordingIdMinValue() {
        return -9223372036854775807L;
    }

    public static long fromRecordingIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public ListRecordingsRequestEncoder fromRecordingId(long value) {
        this.buffer.putLong(this.offset + 16, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int recordCountEncodingOffset() {
        return 24;
    }

    public static int recordCountEncodingLength() {
        return 4;
    }

    public static int recordCountNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int recordCountMinValue() {
        return -2147483647;
    }

    public static int recordCountMaxValue() {
        return Integer.MAX_VALUE;
    }

    public ListRecordingsRequestEncoder recordCount(int value) {
        this.buffer.putInt(this.offset + 24, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        ListRecordingsRequestDecoder writer = new ListRecordingsRequestDecoder();
        writer.wrap(this.buffer, this.offset, 28, 0);
        return writer.appendTo(builder);
    }
}

