/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.RecordingDescriptorHeaderDecoder;
import java.nio.ByteOrder;
import org.agrona.MutableDirectBuffer;

public class RecordingDescriptorHeaderEncoder {
    public static final int BLOCK_LENGTH = 32;
    public static final int TEMPLATE_ID = 10;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    private final RecordingDescriptorHeaderEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    protected int offset;
    protected int limit;

    public int sbeBlockLength() {
        return 32;
    }

    public int sbeTemplateId() {
        return 10;
    }

    public int sbeSchemaId() {
        return 1;
    }

    public int sbeSchemaVersion() {
        return 0;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public RecordingDescriptorHeaderEncoder wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        this.limit(offset + 32);
        return this;
    }

    public RecordingDescriptorHeaderEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(32).templateId(10).schemaId(1).version(0);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int lengthEncodingOffset() {
        return 0;
    }

    public static int lengthEncodingLength() {
        return 4;
    }

    public static int lengthNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int lengthMinValue() {
        return -2147483647;
    }

    public static int lengthMaxValue() {
        return Integer.MAX_VALUE;
    }

    public RecordingDescriptorHeaderEncoder length(int value) {
        this.buffer.putInt(this.offset + 0, value, ByteOrder.LITTLE_ENDIAN);
        return this;
    }

    public static int validEncodingOffset() {
        return 4;
    }

    public static int validEncodingLength() {
        return 1;
    }

    public static byte validNullValue() {
        return -128;
    }

    public static byte validMinValue() {
        return -127;
    }

    public static byte validMaxValue() {
        return 127;
    }

    public RecordingDescriptorHeaderEncoder valid(byte value) {
        this.buffer.putByte(this.offset + 4, value);
        return this;
    }

    public static int reservedEncodingOffset() {
        return 31;
    }

    public static int reservedEncodingLength() {
        return 1;
    }

    public static byte reservedNullValue() {
        return -128;
    }

    public static byte reservedMinValue() {
        return -127;
    }

    public static byte reservedMaxValue() {
        return 127;
    }

    public RecordingDescriptorHeaderEncoder reserved(byte value) {
        this.buffer.putByte(this.offset + 31, value);
        return this;
    }

    public String toString() {
        return this.appendTo(new StringBuilder(100)).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        RecordingDescriptorHeaderDecoder writer = new RecordingDescriptorHeaderDecoder();
        writer.wrap(this.buffer, this.offset, 32, 0);
        return writer.appendTo(builder);
    }
}

