/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.codecs;

public enum SourceLocation {
    LOCAL(0),
    REMOTE(1),
    NULL_VAL(255);

    private final short value;

    private SourceLocation(short value) {
        this.value = value;
    }

    public short value() {
        return this.value;
    }

    public static SourceLocation get(short value) {
        switch (value) {
            case 0: {
                return LOCAL;
            }
            case 1: {
                return REMOTE;
            }
        }
        if (255 == value) {
            return NULL_VAL;
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

