/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import org.agrona.MutableDirectBuffer;

public class ImageBuffersReadyFlyweight {
    private static final int CORRELATION_ID_OFFSET = 0;
    private static final int SESSION_ID_OFFSET = 8;
    private static final int STREAM_ID_FIELD_OFFSET = 12;
    private static final int SUBSCRIBER_REGISTRATION_ID_OFFSET = 16;
    private static final int SUBSCRIBER_POSITION_ID_OFFSET = 24;
    private static final int LOG_FILE_NAME_OFFSET = 28;
    private MutableDirectBuffer buffer;
    private int offset;

    public final ImageBuffersReadyFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        this.buffer = buffer;
        this.offset = offset;
        return this;
    }

    public long correlationId() {
        return this.buffer.getLong(this.offset + 0);
    }

    public ImageBuffersReadyFlyweight correlationId(long correlationId) {
        this.buffer.putLong(this.offset + 0, correlationId);
        return this;
    }

    public int sessionId() {
        return this.buffer.getInt(this.offset + 8);
    }

    public ImageBuffersReadyFlyweight sessionId(int sessionId) {
        this.buffer.putInt(this.offset + 8, sessionId);
        return this;
    }

    public int streamId() {
        return this.buffer.getInt(this.offset + 12);
    }

    public ImageBuffersReadyFlyweight streamId(int streamId) {
        this.buffer.putInt(this.offset + 12, streamId);
        return this;
    }

    public ImageBuffersReadyFlyweight subscriberPositionId(int id) {
        this.buffer.putInt(this.offset + 24, id);
        return this;
    }

    public int subscriberPositionId() {
        return this.buffer.getInt(this.offset + 24);
    }

    public ImageBuffersReadyFlyweight subscriberRegistrationId(long id) {
        this.buffer.putLong(this.offset + 16, id);
        return this;
    }

    public long subscriberRegistrationId() {
        return this.buffer.getLong(this.offset + 16);
    }

    public String logFileName() {
        return this.buffer.getStringAscii(this.offset + 28);
    }

    public ImageBuffersReadyFlyweight logFileName(String logFileName) {
        this.buffer.putStringAscii(this.offset + 28, logFileName);
        return this;
    }

    public String sourceIdentity() {
        return this.buffer.getStringAscii(this.offset + this.sourceIdentityOffset());
    }

    public ImageBuffersReadyFlyweight sourceIdentity(String value) {
        this.buffer.putStringAscii(this.offset + this.sourceIdentityOffset(), value);
        return this;
    }

    public int length() {
        int sourceIdentityOffset = this.sourceIdentityOffset();
        return sourceIdentityOffset + this.buffer.getInt(this.offset + sourceIdentityOffset) + 4;
    }

    private int sourceIdentityOffset() {
        return 28 + this.buffer.getInt(this.offset + 28) + 4;
    }
}

