/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;

public class PublicationLink
implements DriverManagedResource {
    private final long registrationId;
    private final DriverManagedResource publication;
    private final AeronClient client;
    private boolean reachedEndOfLife = false;

    public PublicationLink(long registrationId, DriverManagedResource publication, AeronClient client) {
        this.registrationId = registrationId;
        this.publication = publication;
        this.client = client;
        this.publication.incRef();
    }

    public void close() {
        this.publication.decRef();
    }

    public long registrationId() {
        return this.registrationId;
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (this.client.hasTimedOut(timeNs)) {
            this.reachedEndOfLife = true;
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    @Override
    public void timeOfLastStateChange(long time) {
    }

    @Override
    public long timeOfLastStateChange() {
        return this.client.timeOfLastKeepalive();
    }

    @Override
    public void delete() {
        this.close();
    }
}

