/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ChannelUri;
import io.aeron.driver.Configuration;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.buffer.RawLog;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.logbuffer.LogBufferDescriptor;

class PublicationParams {
    int termLength = 0;
    int mtuLength = 0;
    int initialTermId = 0;
    int termId = 0;
    int termOffset = 0;
    boolean isReplay = false;

    PublicationParams() {
    }

    static int getTermBufferLength(ChannelUri channelUri, int defaultTermLength) {
        String termLengthParam = channelUri.get("term-length");
        int termLength = defaultTermLength;
        if (null != termLengthParam) {
            termLength = Integer.parseInt(termLengthParam);
            LogBufferDescriptor.checkTermLength(termLength);
        }
        return termLength;
    }

    static int getMtuLength(ChannelUri channelUri, int defaultMtuLength) {
        int mtuLength = defaultMtuLength;
        String mtu = channelUri.get("mtu");
        if (null != mtu) {
            mtuLength = Integer.parseInt(mtu);
            Configuration.validateMtuLength(mtuLength);
        }
        return mtuLength;
    }

    static void validateMtuForMaxMessage(PublicationParams params, boolean isExclusive) {
        int maxMessageLength;
        int termLength = params.termLength;
        int n = maxMessageLength = isExclusive ? FrameDescriptor.computeExclusiveMaxMessageLength(termLength) : FrameDescriptor.computeMaxMessageLength(termLength);
        if (params.mtuLength > maxMessageLength) {
            throw new IllegalStateException("MTU greater than max message length for term length: mtu=" + params.mtuLength + " maxMessageLength=" + maxMessageLength + " termLength=" + termLength);
        }
    }

    static void confirmMatch(ChannelUri uri, PublicationParams params, RawLog rawLog) {
        int mtuLength = LogBufferDescriptor.mtuLength(rawLog.metaData());
        if (uri.containsKey("mtu") && mtuLength != params.mtuLength) {
            throw new IllegalStateException("Existing publication has different MTU length: existing=" + mtuLength + " requested=" + params.mtuLength);
        }
        if (uri.containsKey("term-length") && rawLog.termLength() != params.termLength) {
            throw new IllegalStateException("Existing publication has different term length: existing=" + rawLog.termLength() + " requested=" + params.termLength);
        }
    }

    static PublicationParams getPublicationParams(MediaDriver.Context context, ChannelUri channelUri, boolean isExclusive, boolean isIpc) {
        PublicationParams params = new PublicationParams();
        params.termLength = PublicationParams.getTermBufferLength(channelUri, isIpc ? context.ipcTermBufferLength() : context.publicationTermBufferLength());
        params.mtuLength = PublicationParams.getMtuLength(channelUri, isIpc ? context.ipcMtuLength() : context.mtuLength());
        if (isExclusive) {
            int count = 0;
            String initialTermIdStr = channelUri.get("init-term-id");
            count = initialTermIdStr != null ? count + 1 : count;
            String termIdStr = channelUri.get("term-id");
            count = termIdStr != null ? count + 1 : count;
            String termOffsetStr = channelUri.get("term-offset");
            int n = count = termOffsetStr != null ? count + 1 : count;
            if (count > 0) {
                if (count < 3) {
                    throw new IllegalArgumentException("Params must be used as a complete set: init-term-id term-id term-offset");
                }
                params.initialTermId = Integer.parseInt(initialTermIdStr);
                params.termId = Integer.parseInt(termIdStr);
                params.termOffset = Integer.parseInt(termOffsetStr);
                if (params.termOffset > params.termLength) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " > " + "term-length" + "=" + params.termLength);
                }
                if (params.termOffset < 0) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be greater than zero");
                }
                if ((params.termOffset & 0x1F) != 0) {
                    throw new IllegalArgumentException("term-offset=" + params.termOffset + " must be a multiple of FRAME_ALIGNMENT");
                }
                params.isReplay = true;
            }
        }
        return params;
    }
}

