/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.protocol.StatusMessageFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.PortUnreachableException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayListUtil;
import org.agrona.concurrent.NanoClock;

public class UdpDestinationTracker {
    private final ArrayList<Destination> destinationList = new ArrayList();
    private final NanoClock nanoClock;
    private final PreSendFunction preSendFunction;
    private final long destinationTimeoutNs;

    public UdpDestinationTracker(NanoClock nanoClock, PreSendFunction preSendFunction, long timeout) {
        this.nanoClock = nanoClock;
        this.preSendFunction = preSendFunction;
        this.destinationTimeoutNs = timeout;
    }

    public UdpDestinationTracker(PreSendFunction preSendFunction) {
        this.nanoClock = () -> 0L;
        this.preSendFunction = preSendFunction;
        this.destinationTimeoutNs = 0L;
    }

    public int sendToDestinations(DatagramChannel sendDatagramChannel, ByteBuffer buffer) {
        int lastIndex;
        ArrayList<Destination> destinationList = this.destinationList;
        long nowNs = this.nanoClock.nanoTime();
        int minByteSent = buffer.remaining();
        for (int i = lastIndex = destinationList.size() - 1; i >= 0; --i) {
            Destination destination = destinationList.get(i);
            if (nowNs > destination.timeOfLastActivityNs + this.destinationTimeoutNs) {
                ArrayListUtil.fastUnorderedRemove(destinationList, i, lastIndex);
                --lastIndex;
                continue;
            }
            int byteSent = 0;
            try {
                this.preSendFunction.presend(buffer, destination.address);
                int position = buffer.position();
                byteSent = sendDatagramChannel.send(buffer, destination.address);
                buffer.position(position);
            }
            catch (PortUnreachableException | ClosedChannelException position) {
            }
            catch (IOException ex) {
                LangUtil.rethrowUnchecked(ex);
            }
            minByteSent = Math.min(minByteSent, byteSent);
        }
        return minByteSent;
    }

    public void destinationActivity(StatusMessageFlyweight msg, InetSocketAddress destAddress) {
        if (this.destinationTimeoutNs > 0L) {
            ArrayList<Destination> destinationList = this.destinationList;
            long nowNs = this.nanoClock.nanoTime();
            boolean isExisting = false;
            long receiverId = msg.receiverId();
            int size = destinationList.size();
            for (int i = 0; i < size; ++i) {
                Destination destination = destinationList.get(i);
                if (receiverId != destination.receiverId || destAddress.getPort() != destination.port) continue;
                destination.timeOfLastActivityNs = nowNs;
                isExisting = true;
                break;
            }
            if (!isExisting) {
                destinationList.add(new Destination(nowNs, receiverId, destAddress));
            }
        }
    }

    public boolean isManualControlMode() {
        return this.destinationTimeoutNs == 0L;
    }

    public void addDestination(InetSocketAddress address) {
        this.destinationList.add(new Destination(Long.MAX_VALUE, 0L, address));
    }

    public void removeDestination(InetSocketAddress address) {
        int lastIndex;
        ArrayList<Destination> destinationList = this.destinationList;
        for (int i = lastIndex = destinationList.size() - 1; i >= 0; --i) {
            Destination destination = destinationList.get(i);
            if (!address.equals(destination.address)) continue;
            ArrayListUtil.fastUnorderedRemove(destinationList, i, lastIndex);
            break;
        }
    }

    public static class Destination {
        long timeOfLastActivityNs;
        long receiverId;
        int port;
        InetSocketAddress address;

        Destination(long now, long receiverId, InetSocketAddress address) {
            this.timeOfLastActivityNs = now;
            this.receiverId = receiverId;
            this.address = address;
            this.port = address.getPort();
        }
    }

    public static interface PreSendFunction {
        public void presend(ByteBuffer var1, InetSocketAddress var2);
    }
}

