/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.reports;

import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;

public class LossReportReader {
    public static int read(AtomicBuffer buffer, EntryConsumer entryConsumer) {
        long observationCount;
        int recordLength;
        int capacity = buffer.capacity();
        int recordsRead = 0;
        for (int offset = 0; offset < capacity && (observationCount = buffer.getLongVolatile(offset + 0)) > 0L; offset += BitUtil.align(recordLength, 64)) {
            ++recordsRead;
            String channel = buffer.getStringAscii(offset + 40);
            String source = buffer.getStringAscii(offset + 40 + 4 + channel.length());
            entryConsumer.accept(observationCount, buffer.getLong(offset + 8), buffer.getLong(offset + 16), buffer.getLong(offset + 24), buffer.getInt(offset + 32), buffer.getInt(offset + 36), channel, source);
            recordLength = 48 + channel.length() + source.length();
        }
        return recordsRead;
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(long var1, long var3, long var5, long var7, int var9, int var10, String var11, String var12);
    }
}

