/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class LogBufferDescriptor {
    public static final int PARTITION_COUNT = 3;
    public static final int LOG_META_DATA_SECTION_INDEX = 3;
    public static final int TERM_MIN_LENGTH = 65536;
    public static final int TERM_MAX_LENGTH = 0x40000000;
    public static final int TERM_TAIL_COUNTERS_OFFSET;
    public static final int LOG_ACTIVE_PARTITION_INDEX_OFFSET;
    public static final int LOG_TIME_OF_LAST_SM_OFFSET;
    public static final int LOG_END_OF_STREAM_POSITION_OFFSET;
    public static final int LOG_INITIAL_TERM_ID_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET;
    public static final int LOG_MTU_LENGTH_OFFSET;
    public static final int LOG_CORRELATION_ID_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_OFFSET;
    public static final int LOG_DEFAULT_FRAME_HEADER_MAX_LENGTH = 128;
    public static final int LOG_META_DATA_LENGTH;

    public static void checkTermLength(int termLength) {
        if (termLength < 65536) {
            throw new IllegalStateException("Term length less than min length of 65536: length=" + termLength);
        }
        if (termLength > 0x40000000) {
            throw new IllegalStateException("Term length more than max length of 1073741824: length=" + termLength);
        }
        if (!BitUtil.isPowerOfTwo(termLength)) {
            throw new IllegalStateException("Term length not a power of 2: length=" + termLength);
        }
    }

    public static int initialTermId(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_INITIAL_TERM_ID_OFFSET);
    }

    public static void initialTermId(UnsafeBuffer logMetaDataBuffer, int initialTermId) {
        logMetaDataBuffer.putInt(LOG_INITIAL_TERM_ID_OFFSET, initialTermId);
    }

    public static int mtuLength(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getInt(LOG_MTU_LENGTH_OFFSET);
    }

    public static void mtuLength(UnsafeBuffer logMetaDataBuffer, int mtuLength) {
        logMetaDataBuffer.putInt(LOG_MTU_LENGTH_OFFSET, mtuLength);
    }

    public static long correlationId(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getLong(LOG_CORRELATION_ID_OFFSET);
    }

    public static void correlationId(UnsafeBuffer logMetaDataBuffer, long id) {
        logMetaDataBuffer.putLong(LOG_CORRELATION_ID_OFFSET, id);
    }

    public static long timeOfLastStatusMessage(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getLongVolatile(LOG_TIME_OF_LAST_SM_OFFSET);
    }

    public static void timeOfLastStatusMessage(UnsafeBuffer logMetaDataBuffer, long timeInMillis) {
        logMetaDataBuffer.putLongOrdered(LOG_TIME_OF_LAST_SM_OFFSET, timeInMillis);
    }

    public static long endOfStreamPosition(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getLongVolatile(LOG_END_OF_STREAM_POSITION_OFFSET);
    }

    public static void endOfStreamPosition(UnsafeBuffer logMetaDataBuffer, long position) {
        logMetaDataBuffer.putLongOrdered(LOG_END_OF_STREAM_POSITION_OFFSET, position);
    }

    public static int activePartitionIndex(UnsafeBuffer logMetaDataBuffer) {
        return logMetaDataBuffer.getIntVolatile(LOG_ACTIVE_PARTITION_INDEX_OFFSET);
    }

    public static void activePartitionIndexOrdered(UnsafeBuffer logMetaDataBuffer, int activePartitionIndex) {
        logMetaDataBuffer.putIntOrdered(LOG_ACTIVE_PARTITION_INDEX_OFFSET, activePartitionIndex);
    }

    public static void activePartitionIndex(UnsafeBuffer logMetaDataBuffer, int activePartitionIndex) {
        logMetaDataBuffer.putInt(LOG_ACTIVE_PARTITION_INDEX_OFFSET, activePartitionIndex);
    }

    public static int nextPartitionIndex(int currentIndex) {
        return (currentIndex + 1) % 3;
    }

    public static int indexByTerm(int initialTermId, int activeTermId) {
        return (activeTermId - initialTermId) % 3;
    }

    public static int indexByTermCount(long termCount) {
        return (int)(termCount % 3L);
    }

    public static int indexByPosition(long position, int positionBitsToShift) {
        return (int)((position >>> positionBitsToShift) % 3L);
    }

    public static long computePosition(int activeTermId, int termOffset, int positionBitsToShift, int initialTermId) {
        long termCount = activeTermId - initialTermId;
        return (termCount << positionBitsToShift) + (long)termOffset;
    }

    public static long computeTermBeginPosition(int activeTermId, int positionBitsToShift, int initialTermId) {
        long termCount = activeTermId - initialTermId;
        return termCount << positionBitsToShift;
    }

    public static int computeTermIdFromPosition(long position, int positionBitsToShift, int initialTermId) {
        return (int)(position >>> positionBitsToShift) + initialTermId;
    }

    public static int computeTermOffsetFromPosition(long position, int positionBitsToShift) {
        long mask = (1L << positionBitsToShift) - 1L;
        return (int)(position & mask);
    }

    public static long computeLogLength(int termLength) {
        return termLength * 3 + LOG_META_DATA_LENGTH;
    }

    public static int computeTermLength(long logLength) {
        return (int)((logLength - (long)LOG_META_DATA_LENGTH) / 3L);
    }

    public static void storeDefaultFrameHeader(UnsafeBuffer logMetaDataBuffer, DirectBuffer defaultHeader) {
        if (defaultHeader.capacity() != 32) {
            throw new IllegalArgumentException("Default header of not equals to HEADER_LENGTH: length=" + defaultHeader.capacity());
        }
        logMetaDataBuffer.putInt(LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET, 32);
        logMetaDataBuffer.putBytes(LOG_DEFAULT_FRAME_HEADER_OFFSET, defaultHeader, 0, 32);
    }

    public static UnsafeBuffer defaultFrameHeader(UnsafeBuffer logMetaDataBuffer) {
        return new UnsafeBuffer(logMetaDataBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static void applyDefaultHeader(UnsafeBuffer logMetaDataBuffer, UnsafeBuffer termBuffer, int termOffset) {
        termBuffer.putBytes(termOffset, logMetaDataBuffer, LOG_DEFAULT_FRAME_HEADER_OFFSET, 32);
    }

    public static void rotateLog(UnsafeBuffer logMetaDataBuffer, int activePartitionIndex, int termId) {
        int nextIndex = LogBufferDescriptor.nextPartitionIndex(activePartitionIndex);
        LogBufferDescriptor.initialiseTailWithTermId(logMetaDataBuffer, nextIndex, termId);
        LogBufferDescriptor.activePartitionIndexOrdered(logMetaDataBuffer, nextIndex);
    }

    public static void initialiseTailWithTermId(UnsafeBuffer logMetaData, int partitionIndex, int termId) {
        logMetaData.putLong(TERM_TAIL_COUNTERS_OFFSET + partitionIndex * 8, LogBufferDescriptor.packTail(termId, 0));
    }

    public static int termId(long rawTail) {
        return (int)(rawTail >> 32);
    }

    public static int termOffset(long rawTail, long termLength) {
        long tail = rawTail & 0xFFFFFFFFL;
        return (int)Math.min(tail, termLength);
    }

    public static int termOffset(long result) {
        return (int)result;
    }

    public static long packTail(int termId, int termOffset) {
        return (long)termId << 32 | (long)termOffset & 0xFFFFFFFFL;
    }

    public static void rawTail(UnsafeBuffer logMetaDataBuffer, int partitionIndex, long rawTail) {
        logMetaDataBuffer.putLong(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex, rawTail);
    }

    public static long rawTail(UnsafeBuffer logMetaDataBuffer, int partitionIndex) {
        return logMetaDataBuffer.getLong(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    public static void rawTailVolatile(UnsafeBuffer logMetaDataBuffer, int partitionIndex, long rawTail) {
        logMetaDataBuffer.putLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex, rawTail);
    }

    public static long rawTailVolatile(UnsafeBuffer logMetaDataBuffer, int partitionIndex) {
        return logMetaDataBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    public static long rawTailVolatile(UnsafeBuffer logMetaDataBuffer) {
        int partitionIndex = LogBufferDescriptor.activePartitionIndex(logMetaDataBuffer);
        return logMetaDataBuffer.getLongVolatile(TERM_TAIL_COUNTERS_OFFSET + 8 * partitionIndex);
    }

    static {
        int offset;
        TERM_TAIL_COUNTERS_OFFSET = offset = 0;
        LOG_ACTIVE_PARTITION_INDEX_OFFSET = offset += 24;
        LOG_TIME_OF_LAST_SM_OFFSET = offset = 128;
        LOG_END_OF_STREAM_POSITION_OFFSET = LOG_TIME_OF_LAST_SM_OFFSET + 8;
        LOG_CORRELATION_ID_OFFSET = offset += 128;
        LOG_INITIAL_TERM_ID_OFFSET = LOG_CORRELATION_ID_OFFSET + 8;
        LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET = LOG_INITIAL_TERM_ID_OFFSET + 4;
        LOG_MTU_LENGTH_OFFSET = LOG_DEFAULT_FRAME_HEADER_LENGTH_OFFSET + 4;
        LOG_DEFAULT_FRAME_HEADER_OFFSET = offset += 64;
        LOG_META_DATA_LENGTH = offset + 128;
    }
}

