/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.Image;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.ThreadingMode;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import io.aeron.samples.SampleConfiguration;
import io.aeron.shadow.org.HdrHistogram.Histogram;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.NoOpIdleStrategy;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.console.ContinueBarrier;

public class EmbeddedPingPong {
    private static final int PING_STREAM_ID = SampleConfiguration.PING_STREAM_ID;
    private static final int PONG_STREAM_ID = SampleConfiguration.PONG_STREAM_ID;
    private static final int NUMBER_OF_MESSAGES = SampleConfiguration.NUMBER_OF_MESSAGES;
    private static final int WARMUP_NUMBER_OF_MESSAGES = SampleConfiguration.WARMUP_NUMBER_OF_MESSAGES;
    private static final int WARMUP_NUMBER_OF_ITERATIONS = SampleConfiguration.WARMUP_NUMBER_OF_ITERATIONS;
    private static final int MESSAGE_LENGTH = SampleConfiguration.MESSAGE_LENGTH;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final int FRAME_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;
    private static final String PING_CHANNEL = SampleConfiguration.PING_CHANNEL;
    private static final String PONG_CHANNEL = SampleConfiguration.PONG_CHANNEL;
    private static final UnsafeBuffer ATOMIC_BUFFER = new UnsafeBuffer(BufferUtil.allocateDirectAligned(MESSAGE_LENGTH, 64));
    private static final Histogram HISTOGRAM = new Histogram(TimeUnit.SECONDS.toNanos(10L), 3);
    private static final CountDownLatch PONG_IMAGE_LATCH = new CountDownLatch(1);
    private static final BusySpinIdleStrategy PING_HANDLER_IDLE_STRATEGY = new BusySpinIdleStrategy();
    private static final BusySpinIdleStrategy PONG_HANDLER_IDLE_STRATEGY = new BusySpinIdleStrategy();
    private static final AtomicBoolean RUNNING = new AtomicBoolean(true);

    public static void main(String[] args) throws Exception {
        MediaDriver.loadPropertiesFiles(args);
        MediaDriver.Context ctx = new MediaDriver.Context().threadingMode(ThreadingMode.DEDICATED).conductorIdleStrategy(new BackoffIdleStrategy(1L, 1L, 1L, 1L)).receiverIdleStrategy(new NoOpIdleStrategy()).senderIdleStrategy(new NoOpIdleStrategy());
        try (MediaDriver ignored = MediaDriver.launch(ctx);){
            Thread pongThread = EmbeddedPingPong.startPong(ignored.aeronDirectoryName());
            pongThread.start();
            EmbeddedPingPong.runPing(ignored.aeronDirectoryName());
            RUNNING.set(false);
            pongThread.join();
            System.out.println("Shutdown Driver...");
        }
    }

    private static void runPing(String embeddedDirName) throws InterruptedException {
        Aeron.Context ctx = new Aeron.Context().availableImageHandler(EmbeddedPingPong::availablePongImageHandler).aeronDirectoryName(embeddedDirName);
        System.out.println("Publishing Ping at " + PING_CHANNEL + " on stream Id " + PING_STREAM_ID);
        System.out.println("Subscribing Pong at " + PONG_CHANNEL + " on stream Id " + PONG_STREAM_ID);
        System.out.println("Message size of " + MESSAGE_LENGTH + " bytes");
        FragmentAssembler dataHandler = new FragmentAssembler(EmbeddedPingPong::pongHandler);
        try (Aeron aeron = Aeron.connect(ctx);
             Publication pingPublication = aeron.addPublication(PING_CHANNEL, PING_STREAM_ID);
             Subscription pongSubscription = aeron.addSubscription(PONG_CHANNEL, PONG_STREAM_ID);){
            System.out.println("Waiting for new image from Pong...");
            PONG_IMAGE_LATCH.await();
            System.out.println("Warming up... " + WARMUP_NUMBER_OF_ITERATIONS + " iterations of " + WARMUP_NUMBER_OF_MESSAGES + " messages");
            for (int i = 0; i < WARMUP_NUMBER_OF_ITERATIONS; ++i) {
                EmbeddedPingPong.roundTripMessages(dataHandler, pingPublication, pongSubscription, WARMUP_NUMBER_OF_MESSAGES);
            }
            Thread.sleep(100L);
            ContinueBarrier barrier = new ContinueBarrier("Execute again?");
            do {
                HISTOGRAM.reset();
                System.out.println("Pinging " + NUMBER_OF_MESSAGES + " messages");
                EmbeddedPingPong.roundTripMessages(dataHandler, pingPublication, pongSubscription, NUMBER_OF_MESSAGES);
                System.out.println("Histogram of RTT latencies in microseconds.");
                HISTOGRAM.outputPercentileDistribution(System.out, 1000.0);
            } while (barrier.await());
        }
    }

    private static Thread startPong(final String embeddedDirName) {
        return new Thread(){

            @Override
            public void run() {
                System.out.println("Subscribing Ping at " + PING_CHANNEL + " on stream Id " + PING_STREAM_ID);
                System.out.println("Publishing Pong at " + PONG_CHANNEL + " on stream Id " + PONG_STREAM_ID);
                Aeron.Context ctx = new Aeron.Context().aeronDirectoryName(embeddedDirName);
                try (Aeron aeron = Aeron.connect(ctx);
                     Publication pongPublication = aeron.addPublication(PONG_CHANNEL, PONG_STREAM_ID);
                     Subscription pingSubscription = aeron.addSubscription(PING_CHANNEL, PING_STREAM_ID);){
                    FragmentAssembler dataHandler = new FragmentAssembler((buffer, offset, length, header) -> EmbeddedPingPong.pingHandler(pongPublication, buffer, offset, length));
                    while (RUNNING.get()) {
                        PING_HANDLER_IDLE_STRATEGY.idle(pingSubscription.poll(dataHandler, FRAME_COUNT_LIMIT));
                    }
                    System.out.println("Shutting down...");
                }
            }
        };
    }

    private static void roundTripMessages(FragmentHandler fragmentHandler, Publication pingPublication, Subscription pongSubscription, int numMessages) {
        while (pongSubscription.hasNoImages()) {
            Thread.yield();
        }
        Image image = pongSubscription.imageAtIndex(0);
        block1: for (int i = 0; i < numMessages; ++i) {
            long offeredPosition;
            do {
                ATOMIC_BUFFER.putLong(0, System.nanoTime());
            } while ((offeredPosition = pingPublication.offer(ATOMIC_BUFFER, 0, MESSAGE_LENGTH)) < 0L);
            PONG_HANDLER_IDLE_STRATEGY.reset();
            while (true) {
                if (image.poll(fragmentHandler, FRAGMENT_COUNT_LIMIT) <= 0) {
                    PONG_HANDLER_IDLE_STRATEGY.idle();
                    continue;
                }
                if (image.position() >= offeredPosition) continue block1;
            }
        }
    }

    private static void pongHandler(DirectBuffer buffer, int offset, int length, Header header) {
        long pingTimestamp = buffer.getLong(offset);
        long rttNs = System.nanoTime() - pingTimestamp;
        HISTOGRAM.recordValue(rttNs);
    }

    private static void availablePongImageHandler(Image image) {
        Subscription subscription = image.subscription();
        if (PONG_STREAM_ID == subscription.streamId() && PONG_CHANNEL.equals(subscription.channel())) {
            PONG_IMAGE_LATCH.countDown();
        }
    }

    public static void pingHandler(Publication pongPublication, DirectBuffer buffer, int offset, int length) {
        if (pongPublication.offer(buffer, offset, length) > 0L) {
            return;
        }
        PING_HANDLER_IDLE_STRATEGY.reset();
        while (pongPublication.offer(buffer, offset, length) < 0L) {
            PING_HANDLER_IDLE_STRATEGY.idle();
        }
    }
}

