/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.EndOfStreamHandler;
import io.aeron.Image;
import io.aeron.Subscription;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.protocol.HeaderFlyweight;
import io.aeron.samples.RateReporter;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.agrona.LangUtil;
import org.agrona.concurrent.BusySpinIdleStrategy;
import org.agrona.concurrent.IdleStrategy;

public class SamplesUtil {
    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, int limit, AtomicBoolean running) {
        BusySpinIdleStrategy idleStrategy = new BusySpinIdleStrategy();
        return SamplesUtil.subscriberLoop(fragmentHandler, SamplesUtil::printEndOfStreamImage, limit, running, idleStrategy);
    }

    public static Consumer<Subscription> subscriberLoop(FragmentHandler fragmentHandler, EndOfStreamHandler endOfStreamHandler, int limit, AtomicBoolean running, IdleStrategy idleStrategy) {
        return subscription -> {
            try {
                boolean reachedEos = false;
                while (running.get()) {
                    int fragmentsRead = subscription.poll(fragmentHandler, limit);
                    if (0 == fragmentsRead && !reachedEos && subscription.pollEndOfStreams(endOfStreamHandler) > 0) {
                        reachedEos = true;
                    }
                    idleStrategy.idle(fragmentsRead);
                }
            }
            catch (Exception ex) {
                LangUtil.rethrowUnchecked(ex);
            }
        };
    }

    public static FragmentHandler printStringMessage(int streamId) {
        return (buffer, offset, length, header) -> {
            byte[] data = new byte[length];
            buffer.getBytes(offset, data);
            System.out.println(String.format("Message to stream %d from session %d (%d@%d) <<%s>>", streamId, header.sessionId(), length, offset, new String(data)));
        };
    }

    public static FragmentHandler rateReporterHandler(RateReporter reporter) {
        return (buffer, offset, length, header) -> reporter.onMessage(1L, length);
    }

    public static void printError(String channel, int streamId, int sessionId, String message, HeaderFlyweight cause) {
        System.out.println(message);
    }

    public static void printRate(double messagesPerSec, double bytesPerSec, long totalMessages, long totalBytes) {
        System.out.println(String.format("%.02g msgs/sec, %.02g bytes/sec, totals %d messages %d MB", messagesPerSec, bytesPerSec, totalMessages, totalBytes / 0x100000L));
    }

    public static void printAvailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Available image on %s streamId=%d sessionId=%d from %s", subscription.channel(), subscription.streamId(), image.sessionId(), image.sourceIdentity()));
    }

    public static void printUnavailableImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("Unavailable image on %s streamId=%d sessionId=%d", subscription.channel(), subscription.streamId(), image.sessionId()));
    }

    public static void printEndOfStreamImage(Image image) {
        Subscription subscription = image.subscription();
        System.out.println(String.format("End Of Stream image on %s streamId=%d sessionId=%d from %s", subscription.channel(), subscription.streamId(), image.sessionId(), image.sourceIdentity()));
    }
}

