/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples;

import io.aeron.Aeron;
import io.aeron.driver.status.SystemCounterDescriptor;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.status.CountersReader;
import org.agrona.concurrent.status.StatusIndicator;
import org.agrona.concurrent.status.UnsafeBufferStatusIndicator;

public class SetControllableIdleStrategy {
    public static void main(String[] args) throws Exception {
        try (Aeron aeron = Aeron.connect();){
            CountersReader countersReader = aeron.countersReader();
            MutableInteger id = new MutableInteger();
            id.value = -1;
            countersReader.forEach((counterId, typeId, keyBuffer, label) -> {
                if (counterId == SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.id() && label.equals(SystemCounterDescriptor.CONTROLLABLE_IDLE_STRATEGY.label())) {
                    id.value = counterId;
                }
            });
            if (-1 != id.value) {
                UnsafeBufferStatusIndicator statusIndicator = new UnsafeBufferStatusIndicator(countersReader.valuesBuffer(), id.value);
                int status = Integer.parseInt(args[0]);
                ((StatusIndicator)statusIndicator).setOrdered(status);
                System.out.println("Set ControllableIdleStrategy status to " + status);
            } else {
                System.out.println("Could not find ControllableIdleStrategy status.");
            }
        }
    }
}

