/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.samples.archive;

import io.aeron.Subscription;
import io.aeron.archive.client.AeronArchive;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.samples.SampleConfiguration;
import io.aeron.samples.SamplesUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.SigInt;

public class ReplayedBasicSubscriber {
    private static final int STREAM_ID = SampleConfiguration.STREAM_ID;
    private static final int REPLAY_STREAM_ID = SampleConfiguration.STREAM_ID + 1;
    private static final String CHANNEL = SampleConfiguration.CHANNEL;
    private static final int FRAGMENT_COUNT_LIMIT = SampleConfiguration.FRAGMENT_COUNT_LIMIT;

    public static void main(String[] args) throws Exception {
        System.out.println("Subscribing to " + CHANNEL + " on stream Id " + STREAM_ID);
        FragmentHandler fragmentHandler = SamplesUtil.printStringMessage(STREAM_ID);
        AtomicBoolean running = new AtomicBoolean(true);
        SigInt.register(() -> running.set(false));
        try (AeronArchive archive = AeronArchive.connect();){
            long recordingId = ReplayedBasicSubscriber.findLatestRecording(archive, CHANNEL, STREAM_ID);
            long position = 0L;
            long length = Long.MAX_VALUE;
            try (Subscription subscription = archive.replay(recordingId, 0L, Long.MAX_VALUE, CHANNEL, REPLAY_STREAM_ID);){
                SamplesUtil.subscriberLoop(fragmentHandler, FRAGMENT_COUNT_LIMIT, running).accept(subscription);
                System.out.println("Shutting down...");
            }
        }
    }

    private static long findLatestRecording(AeronArchive archive, String expectedChannel, int expectedStreamId) {
        MutableLong foundRecordingId = new MutableLong();
        int recordingsFound = archive.listRecordingsForUri(0L, 100, expectedChannel, expectedStreamId, (controlSessionId, correlationId, recordingId, startTimestamp, stopTimestamp, startPosition, stopPosition, initialTermId, segmentFileLength, termBufferLength, mtuLength, sessionId, streamId, strippedChannel, originalChannel, sourceIdentity) -> foundRecordingId.set(recordingId));
        if (recordingsFound == 0) {
            throw new IllegalStateException("No recordings found for channel=" + expectedChannel + " streamId=" + expectedStreamId);
        }
        return foundRecordingId.get();
    }
}

