/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent;

import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.agrona.ErrorHandler;
import org.agrona.concurrent.Agent;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.status.AtomicCounter;

public class AgentRunner
implements Runnable,
AutoCloseable {
    public static final Thread TOMBSTONE = new Thread();
    private static final int RETRY_CLOSE_TIMEOUT_MS = 3000;
    private volatile boolean isRunning = true;
    private volatile boolean isClosed = false;
    private final AtomicCounter errorCounter;
    private final ErrorHandler errorHandler;
    private final IdleStrategy idleStrategy;
    private final Agent agent;
    private final AtomicReference<Thread> thread = new AtomicReference();

    public AgentRunner(IdleStrategy idleStrategy, ErrorHandler errorHandler, AtomicCounter errorCounter, Agent agent) {
        Objects.requireNonNull(idleStrategy, "idleStrategy");
        Objects.requireNonNull(errorHandler, "errorHandler");
        Objects.requireNonNull(agent, "agent");
        this.idleStrategy = idleStrategy;
        this.errorHandler = errorHandler;
        this.errorCounter = errorCounter;
        this.agent = agent;
    }

    public static Thread startOnThread(AgentRunner runner) {
        return AgentRunner.startOnThread(runner, Thread::new);
    }

    public static Thread startOnThread(AgentRunner runner, ThreadFactory threadFactory) {
        Thread thread = threadFactory.newThread(runner);
        thread.setName(runner.agent().roleName());
        thread.start();
        return thread;
    }

    public Agent agent() {
        return this.agent;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Thread thread() {
        return this.thread.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (!this.thread.compareAndSet(null, Thread.currentThread())) {
                return;
            }
            IdleStrategy idleStrategy = this.idleStrategy;
            Agent agent = this.agent;
            try {
                agent.onStart();
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
                this.isRunning = false;
            }
            while (this.isRunning && !this.doDutyCycle(idleStrategy, agent)) {
            }
            try {
                agent.onClose();
            }
            catch (Throwable throwable) {
                this.handleError(throwable);
            }
        }
        finally {
            this.isClosed = true;
        }
    }

    @Override
    public final void close() {
        this.isRunning = false;
        Thread thread = this.thread.getAndSet(TOMBSTONE);
        if (TOMBSTONE != thread && null != thread) {
            try {
                while (true) {
                    thread.join(3000L);
                    if (!thread.isAlive() || this.isClosed) {
                        return;
                    }
                    System.err.println("Timeout waiting for agent '" + this.agent.roleName() + "' to close, Retrying...");
                    if (thread.isInterrupted()) continue;
                    thread.interrupt();
                }
            }
            catch (InterruptedException ignore) {
                return;
            }
        }
    }

    private boolean doDutyCycle(IdleStrategy idleStrategy, Agent agent) {
        try {
            idleStrategy.idle(agent.doWork());
        }
        catch (InterruptedException | ClosedByInterruptException ignore) {
            Thread.interrupted();
            return true;
        }
        catch (AgentTerminationException ex) {
            this.handleError(ex);
            return true;
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        return false;
    }

    private void handleError(Throwable throwable) {
        if (this.isRunning) {
            if (null != this.errorCounter) {
                this.errorCounter.increment();
            }
            this.errorHandler.onError(throwable);
        }
    }
}

