/*
 * Decompiled with CFR 0.152.
 */
package rx.observables;

import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Observer;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.annotations.Experimental;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Func0;
import rx.functions.Func2;
import rx.internal.operators.BackpressureUtils;
import rx.plugins.RxJavaPlugins;

@Experimental
public abstract class SyncOnSubscribe<S, T>
implements Observable.OnSubscribe<T> {
    @Override
    public final void call(Subscriber<? super T> subscriber) {
        S state;
        try {
            state = this.generateState();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            subscriber.onError(e);
            return;
        }
        SubscriptionProducer<S, ? super T> p = new SubscriptionProducer<S, T>(subscriber, this, state);
        subscriber.add(p);
        subscriber.setProducer(p);
    }

    protected abstract S generateState();

    protected abstract S next(S var1, Observer<? super T> var2);

    protected void onUnsubscribe(S state) {
    }

    @Experimental
    public static <S, T> Observable.OnSubscribe<T> createSingleState(Func0<? extends S> generator, final Action2<? super S, ? super Observer<? super T>> next) {
        Func2 nextFunc = new Func2<S, Observer<? super T>, S>(){

            @Override
            public S call(S state, Observer<? super T> subscriber) {
                next.call(state, subscriber);
                return state;
            }
        };
        return new SyncOnSubscribeImpl(generator, nextFunc);
    }

    @Experimental
    public static <S, T> Observable.OnSubscribe<T> createSingleState(Func0<? extends S> generator, final Action2<? super S, ? super Observer<? super T>> next, Action1<? super S> onUnsubscribe) {
        Func2 nextFunc = new Func2<S, Observer<? super T>, S>(){

            @Override
            public S call(S state, Observer<? super T> subscriber) {
                next.call(state, subscriber);
                return state;
            }
        };
        return new SyncOnSubscribeImpl(generator, nextFunc, onUnsubscribe);
    }

    @Experimental
    public static <S, T> Observable.OnSubscribe<T> createStateful(Func0<? extends S> generator, Func2<? super S, ? super Observer<? super T>, ? extends S> next, Action1<? super S> onUnsubscribe) {
        return new SyncOnSubscribeImpl(generator, next, onUnsubscribe);
    }

    @Experimental
    public static <S, T> Observable.OnSubscribe<T> createStateful(Func0<? extends S> generator, Func2<? super S, ? super Observer<? super T>, ? extends S> next) {
        return new SyncOnSubscribeImpl(generator, next);
    }

    @Experimental
    public static <T> Observable.OnSubscribe<T> createStateless(final Action1<? super Observer<? super T>> next) {
        Func2 nextFunc = new Func2<Void, Observer<? super T>, Void>(){

            @Override
            public Void call(Void state, Observer<? super T> subscriber) {
                next.call(subscriber);
                return state;
            }
        };
        return new SyncOnSubscribeImpl(nextFunc);
    }

    @Experimental
    public static <T> Observable.OnSubscribe<T> createStateless(final Action1<? super Observer<? super T>> next, final Action0 onUnsubscribe) {
        Func2 nextFunc = new Func2<Void, Observer<? super T>, Void>(){

            @Override
            public Void call(Void state, Observer<? super T> subscriber) {
                next.call(subscriber);
                return null;
            }
        };
        Action1<Void> wrappedOnUnsubscribe = new Action1<Void>(){

            @Override
            public void call(Void t) {
                onUnsubscribe.call();
            }
        };
        return new SyncOnSubscribeImpl(nextFunc, wrappedOnUnsubscribe);
    }

    private static class SubscriptionProducer<S, T>
    extends AtomicLong
    implements Producer,
    Subscription,
    Observer<T> {
        private static final long serialVersionUID = -3736864024352728072L;
        private final Subscriber<? super T> actualSubscriber;
        private final SyncOnSubscribe<S, T> parent;
        private boolean onNextCalled;
        private boolean hasTerminated;
        private S state;

        SubscriptionProducer(Subscriber<? super T> subscriber, SyncOnSubscribe<S, T> parent, S state) {
            this.actualSubscriber = subscriber;
            this.parent = parent;
            this.state = state;
        }

        @Override
        public boolean isUnsubscribed() {
            return this.get() < 0L;
        }

        @Override
        public void unsubscribe() {
            long requestCount;
            do {
                requestCount = this.get();
                if (!this.compareAndSet(0L, -1L)) continue;
                this.doUnsubscribe();
                return;
            } while (!this.compareAndSet(requestCount, -2L));
        }

        private boolean tryUnsubscribe() {
            if (this.hasTerminated || this.get() < -1L) {
                this.set(-1L);
                this.doUnsubscribe();
                return true;
            }
            return false;
        }

        private void doUnsubscribe() {
            try {
                this.parent.onUnsubscribe(this.state);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
            }
        }

        @Override
        public void request(long n) {
            if (n > 0L && BackpressureUtils.getAndAddRequest(this, n) == 0L) {
                if (n == Long.MAX_VALUE) {
                    this.fastpath();
                } else {
                    this.slowPath(n);
                }
            }
        }

        private void fastpath() {
            SyncOnSubscribe<S, T> p = this.parent;
            Subscriber<? super T> a = this.actualSubscriber;
            do {
                try {
                    this.onNextCalled = false;
                    this.nextIteration(p);
                }
                catch (Throwable ex) {
                    this.handleThrownError(a, ex);
                    return;
                }
            } while (!this.tryUnsubscribe());
        }

        private void handleThrownError(Subscriber<? super T> a, Throwable ex) {
            if (this.hasTerminated) {
                RxJavaPlugins.getInstance().getErrorHandler().handleError(ex);
            } else {
                this.hasTerminated = true;
                a.onError(ex);
                this.unsubscribe();
            }
        }

        private void slowPath(long n) {
            SyncOnSubscribe<S, T> p = this.parent;
            Subscriber<? super T> a = this.actualSubscriber;
            long numRequested = n;
            do {
                long numRemaining = numRequested;
                do {
                    try {
                        this.onNextCalled = false;
                        this.nextIteration(p);
                    }
                    catch (Throwable ex) {
                        this.handleThrownError(a, ex);
                        return;
                    }
                    if (this.tryUnsubscribe()) {
                        return;
                    }
                    if (!this.onNextCalled) continue;
                    --numRemaining;
                } while (numRemaining != 0L);
            } while ((numRequested = this.addAndGet(-numRequested)) > 0L);
            this.tryUnsubscribe();
        }

        private void nextIteration(SyncOnSubscribe<S, T> parent) {
            this.state = parent.next(this.state, this);
        }

        @Override
        public void onCompleted() {
            if (this.hasTerminated) {
                throw new IllegalStateException("Terminal event already emitted.");
            }
            this.hasTerminated = true;
            if (!this.actualSubscriber.isUnsubscribed()) {
                this.actualSubscriber.onCompleted();
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.hasTerminated) {
                throw new IllegalStateException("Terminal event already emitted.");
            }
            this.hasTerminated = true;
            if (!this.actualSubscriber.isUnsubscribed()) {
                this.actualSubscriber.onError(e);
            }
        }

        @Override
        public void onNext(T value) {
            if (this.onNextCalled) {
                throw new IllegalStateException("onNext called multiple times!");
            }
            this.onNextCalled = true;
            this.actualSubscriber.onNext(value);
        }
    }

    private static final class SyncOnSubscribeImpl<S, T>
    extends SyncOnSubscribe<S, T> {
        private final Func0<? extends S> generator;
        private final Func2<? super S, ? super Observer<? super T>, ? extends S> next;
        private final Action1<? super S> onUnsubscribe;

        SyncOnSubscribeImpl(Func0<? extends S> generator, Func2<? super S, ? super Observer<? super T>, ? extends S> next, Action1<? super S> onUnsubscribe) {
            this.generator = generator;
            this.next = next;
            this.onUnsubscribe = onUnsubscribe;
        }

        public SyncOnSubscribeImpl(Func0<? extends S> generator, Func2<? super S, ? super Observer<? super T>, ? extends S> next) {
            this(generator, next, null);
        }

        public SyncOnSubscribeImpl(Func2<S, Observer<? super T>, S> next, Action1<? super S> onUnsubscribe) {
            this(null, next, onUnsubscribe);
        }

        public SyncOnSubscribeImpl(Func2<S, Observer<? super T>, S> nextFunc) {
            this(null, nextFunc, null);
        }

        @Override
        protected S generateState() {
            return this.generator == null ? null : (S)this.generator.call();
        }

        @Override
        protected S next(S state, Observer<? super T> observer) {
            return this.next.call(state, observer);
        }

        @Override
        protected void onUnsubscribe(S state) {
            if (this.onUnsubscribe != null) {
                this.onUnsubscribe.call(state);
            }
        }
    }
}

