
package zipkin2;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_DependencyLink extends DependencyLink {

  private final String parent;
  private final String child;
  private final long callCount;
  private final long errorCount;

  private AutoValue_DependencyLink(
      String parent,
      String child,
      long callCount,
      long errorCount) {
    this.parent = parent;
    this.child = child;
    this.callCount = callCount;
    this.errorCount = errorCount;
  }

  @Override
  public String parent() {
    return parent;
  }

  @Override
  public String child() {
    return child;
  }

  @Override
  public long callCount() {
    return callCount;
  }

  @Override
  public long errorCount() {
    return errorCount;
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof DependencyLink) {
      DependencyLink that = (DependencyLink) o;
      return (this.parent.equals(that.parent()))
           && (this.child.equals(that.child()))
           && (this.callCount == that.callCount())
           && (this.errorCount == that.errorCount());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= this.parent.hashCode();
    h *= 1000003;
    h ^= this.child.hashCode();
    h *= 1000003;
    h ^= (int) ((this.callCount >>> 32) ^ this.callCount);
    h *= 1000003;
    h ^= (int) ((this.errorCount >>> 32) ^ this.errorCount);
    return h;
  }

  private static final long serialVersionUID = 0L;

  @Override
  public DependencyLink.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends DependencyLink.Builder {
    private String parent;
    private String child;
    private Long callCount;
    private Long errorCount;
    Builder() {
    }
    private Builder(DependencyLink source) {
      this.parent = source.parent();
      this.child = source.child();
      this.callCount = source.callCount();
      this.errorCount = source.errorCount();
    }
    @Override
    public DependencyLink.Builder parent(String parent) {
      if (parent == null) {
        throw new NullPointerException("Null parent");
      }
      this.parent = parent;
      return this;
    }
    @Override
    String parent() {
      if (parent == null) {
        throw new IllegalStateException("Property \"parent\" has not been set");
      }
      return parent;
    }
    @Override
    public DependencyLink.Builder child(String child) {
      if (child == null) {
        throw new NullPointerException("Null child");
      }
      this.child = child;
      return this;
    }
    @Override
    String child() {
      if (child == null) {
        throw new IllegalStateException("Property \"child\" has not been set");
      }
      return child;
    }
    @Override
    public DependencyLink.Builder callCount(long callCount) {
      this.callCount = callCount;
      return this;
    }
    @Override
    public DependencyLink.Builder errorCount(long errorCount) {
      this.errorCount = errorCount;
      return this;
    }
    @Override
    DependencyLink autoBuild() {
      String missing = "";
      if (this.parent == null) {
        missing += " parent";
      }
      if (this.child == null) {
        missing += " child";
      }
      if (this.callCount == null) {
        missing += " callCount";
      }
      if (this.errorCount == null) {
        missing += " errorCount";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_DependencyLink(
          this.parent,
          this.child,
          this.callCount,
          this.errorCount);
    }
  }

}
