
package zipkin2.storage;

import java.util.Map;
import javax.annotation.Generated;
import zipkin2.internal.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
 final class AutoValue_QueryRequest extends QueryRequest {

  private final String serviceName;
  private final String spanName;
  private final Map<String, String> annotationQuery;
  private final Long minDuration;
  private final Long maxDuration;
  private final long endTs;
  private final long lookback;
  private final int limit;

  private AutoValue_QueryRequest(
      @Nullable String serviceName,
      @Nullable String spanName,
      Map<String, String> annotationQuery,
      @Nullable Long minDuration,
      @Nullable Long maxDuration,
      long endTs,
      long lookback,
      int limit) {
    this.serviceName = serviceName;
    this.spanName = spanName;
    this.annotationQuery = annotationQuery;
    this.minDuration = minDuration;
    this.maxDuration = maxDuration;
    this.endTs = endTs;
    this.lookback = lookback;
    this.limit = limit;
  }

  @Nullable
  @Override
  public String serviceName() {
    return serviceName;
  }

  @Nullable
  @Override
  public String spanName() {
    return spanName;
  }

  @Override
  public Map<String, String> annotationQuery() {
    return annotationQuery;
  }

  @Nullable
  @Override
  public Long minDuration() {
    return minDuration;
  }

  @Nullable
  @Override
  public Long maxDuration() {
    return maxDuration;
  }

  @Override
  public long endTs() {
    return endTs;
  }

  @Override
  public long lookback() {
    return lookback;
  }

  @Override
  public int limit() {
    return limit;
  }

  @Override
  public String toString() {
    return "QueryRequest{"
        + "serviceName=" + serviceName + ", "
        + "spanName=" + spanName + ", "
        + "annotationQuery=" + annotationQuery + ", "
        + "minDuration=" + minDuration + ", "
        + "maxDuration=" + maxDuration + ", "
        + "endTs=" + endTs + ", "
        + "lookback=" + lookback + ", "
        + "limit=" + limit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof QueryRequest) {
      QueryRequest that = (QueryRequest) o;
      return ((this.serviceName == null) ? (that.serviceName() == null) : this.serviceName.equals(that.serviceName()))
           && ((this.spanName == null) ? (that.spanName() == null) : this.spanName.equals(that.spanName()))
           && (this.annotationQuery.equals(that.annotationQuery()))
           && ((this.minDuration == null) ? (that.minDuration() == null) : this.minDuration.equals(that.minDuration()))
           && ((this.maxDuration == null) ? (that.maxDuration() == null) : this.maxDuration.equals(that.maxDuration()))
           && (this.endTs == that.endTs())
           && (this.lookback == that.lookback())
           && (this.limit == that.limit());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h = 1;
    h *= 1000003;
    h ^= (serviceName == null) ? 0 : this.serviceName.hashCode();
    h *= 1000003;
    h ^= (spanName == null) ? 0 : this.spanName.hashCode();
    h *= 1000003;
    h ^= this.annotationQuery.hashCode();
    h *= 1000003;
    h ^= (minDuration == null) ? 0 : this.minDuration.hashCode();
    h *= 1000003;
    h ^= (maxDuration == null) ? 0 : this.maxDuration.hashCode();
    h *= 1000003;
    h ^= (int) ((this.endTs >>> 32) ^ this.endTs);
    h *= 1000003;
    h ^= (int) ((this.lookback >>> 32) ^ this.lookback);
    h *= 1000003;
    h ^= this.limit;
    return h;
  }

  @Override
  public QueryRequest.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends QueryRequest.Builder {
    private String serviceName;
    private String spanName;
    private Map<String, String> annotationQuery;
    private Long minDuration;
    private Long maxDuration;
    private Long endTs;
    private Long lookback;
    private Integer limit;
    Builder() {
    }
    private Builder(QueryRequest source) {
      this.serviceName = source.serviceName();
      this.spanName = source.spanName();
      this.annotationQuery = source.annotationQuery();
      this.minDuration = source.minDuration();
      this.maxDuration = source.maxDuration();
      this.endTs = source.endTs();
      this.lookback = source.lookback();
      this.limit = source.limit();
    }
    @Override
    public QueryRequest.Builder serviceName(@Nullable String serviceName) {
      this.serviceName = serviceName;
      return this;
    }
    @Override
    @Nullable String serviceName() {
      return serviceName;
    }
    @Override
    public QueryRequest.Builder spanName(@Nullable String spanName) {
      this.spanName = spanName;
      return this;
    }
    @Override
    @Nullable String spanName() {
      return spanName;
    }
    @Override
    public QueryRequest.Builder annotationQuery(Map<String, String> annotationQuery) {
      if (annotationQuery == null) {
        throw new NullPointerException("Null annotationQuery");
      }
      this.annotationQuery = annotationQuery;
      return this;
    }
    @Override
    Map<String, String> annotationQuery() {
      if (annotationQuery == null) {
        throw new IllegalStateException("Property \"annotationQuery\" has not been set");
      }
      return annotationQuery;
    }
    @Override
    public QueryRequest.Builder minDuration(@Nullable Long minDuration) {
      this.minDuration = minDuration;
      return this;
    }
    @Override
    @Nullable Long minDuration() {
      return minDuration;
    }
    @Override
    public QueryRequest.Builder maxDuration(@Nullable Long maxDuration) {
      this.maxDuration = maxDuration;
      return this;
    }
    @Override
    @Nullable Long maxDuration() {
      return maxDuration;
    }
    @Override
    public QueryRequest.Builder endTs(long endTs) {
      this.endTs = endTs;
      return this;
    }
    @Override
    long endTs() {
      if (endTs == null) {
        throw new IllegalStateException("Property \"endTs\" has not been set");
      }
      return endTs;
    }
    @Override
    public QueryRequest.Builder lookback(long lookback) {
      this.lookback = lookback;
      return this;
    }
    @Override
    public QueryRequest.Builder limit(int limit) {
      this.limit = limit;
      return this;
    }
    @Override
    int limit() {
      if (limit == null) {
        throw new IllegalStateException("Property \"limit\" has not been set");
      }
      return limit;
    }
    @Override
    QueryRequest autoBuild() {
      String missing = "";
      if (this.annotationQuery == null) {
        missing += " annotationQuery";
      }
      if (this.endTs == null) {
        missing += " endTs";
      }
      if (this.lookback == null) {
        missing += " lookback";
      }
      if (this.limit == null) {
        missing += " limit";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_QueryRequest(
          this.serviceName,
          this.spanName,
          this.annotationQuery,
          this.minDuration,
          this.maxDuration,
          this.endTs,
          this.lookback,
          this.limit);
    }
  }

}
