/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.codec;

import java.util.Collection;
import java.util.List;
import zipkin2.Span;
import zipkin2.codec.BytesDecoder;
import zipkin2.codec.Encoding;
import zipkin2.internal.JsonCodec;
import zipkin2.internal.Nullable;
import zipkin2.internal.Proto3Codec;
import zipkin2.internal.V2SpanReader;

public enum SpanBytesDecoder implements BytesDecoder<Span>
{
    JSON_V2{

        @Override
        public Encoding encoding() {
            return Encoding.JSON;
        }

        @Override
        public boolean decode(byte[] span, Collection<Span> out) {
            return JsonCodec.read(new V2SpanReader(), span, out);
        }

        @Override
        public boolean decodeList(byte[] spans, Collection<Span> out) {
            return JsonCodec.readList(new V2SpanReader(), spans, out);
        }

        @Override
        @Nullable
        public Span decodeOne(byte[] span) {
            return JsonCodec.readOne(new V2SpanReader(), span);
        }

        @Override
        public List<Span> decodeList(byte[] spans) {
            return JsonCodec.readList(new V2SpanReader(), spans);
        }
    }
    ,
    PROTO3{

        @Override
        public Encoding encoding() {
            return Encoding.PROTO3;
        }

        @Override
        public boolean decode(byte[] span, Collection<Span> out) {
            return Proto3Codec.read(span, out);
        }

        @Override
        public boolean decodeList(byte[] spans, Collection<Span> out) {
            return Proto3Codec.readList(spans, out);
        }

        @Override
        @Nullable
        public Span decodeOne(byte[] span) {
            return Proto3Codec.readOne(span);
        }

        @Override
        public List<Span> decodeList(byte[] spans) {
            return Proto3Codec.readList(spans);
        }
    };

}

