/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

public final class Buffer {
    private final byte[] buf;
    int pos;
    static final byte[] DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};

    public Buffer(int size) {
        this.buf = new byte[size];
    }

    Buffer(byte[] buf, int pos) {
        this.buf = buf;
        this.pos = pos;
    }

    public Buffer writeByte(int v) {
        this.buf[this.pos++] = (byte)v;
        return this;
    }

    public Buffer write(byte[] v) {
        System.arraycopy(v, 0, this.buf, this.pos, v.length);
        this.pos += v.length;
        return this;
    }

    static int utf8SizeInBytes(String string) {
        int sizeInBytes = 0;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char low;
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                ++sizeInBytes;
                while (i < len - 1 && (ch = string.charAt(i + 1)) < '\u0080') {
                    ++i;
                    ++sizeInBytes;
                }
                continue;
            }
            if (ch < '\u0800') {
                sizeInBytes += 2;
                continue;
            }
            if (ch < '\ud800' || ch > '\udfff') {
                sizeInBytes += 3;
                continue;
            }
            char c = low = i + 1 < len ? string.charAt(i + 1) : (char)'\u0000';
            if (ch > '\udbff' || low < '\udc00' || low > '\udfff') {
                ++sizeInBytes;
                continue;
            }
            sizeInBytes += 4;
            ++i;
        }
        return sizeInBytes;
    }

    public Buffer writeAscii(String v) {
        int len = v.length();
        for (int i = 0; i < len; ++i) {
            this.buf[this.pos++] = (byte)v.charAt(i);
        }
        return this;
    }

    public Buffer writeUtf8(String string) {
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char low;
            char ch = string.charAt(i);
            if (ch < '\u0080') {
                this.buf[this.pos++] = (byte)ch;
                while (i < len - 1 && (ch = string.charAt(i + 1)) < '\u0080') {
                    ++i;
                    this.buf[this.pos++] = (byte)ch;
                }
                continue;
            }
            if (ch < '\u0800') {
                this.buf[this.pos++] = (byte)(0xC0 | ch >> 6);
                this.buf[this.pos++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (ch < '\ud800' || ch > '\udfff') {
                this.buf[this.pos++] = (byte)(0xE0 | ch >> 12);
                this.buf[this.pos++] = (byte)(0x80 | ch >> 6 & 0x3F);
                this.buf[this.pos++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            if (!Character.isHighSurrogate(ch)) {
                this.buf[this.pos++] = 63;
                continue;
            }
            if (i == len - 1) {
                this.buf[this.pos++] = 63;
                break;
            }
            if (!Character.isLowSurrogate(low = string.charAt(++i))) {
                this.buf[this.pos++] = 63;
                this.buf[this.pos++] = (byte)(Character.isHighSurrogate(low) ? 63 : (int)low);
                continue;
            }
            int codePoint = Character.toCodePoint(ch, low);
            this.buf[this.pos++] = (byte)(0xF0 | codePoint >> 18);
            this.buf[this.pos++] = (byte)(0x80 | codePoint >> 12 & 0x3F);
            this.buf[this.pos++] = (byte)(0x80 | codePoint >> 6 & 0x3F);
            this.buf[this.pos++] = (byte)(0x80 | codePoint & 0x3F);
        }
        return this;
    }

    public static int asciiSizeInBytes(long v) {
        if (v == 0L) {
            return 1;
        }
        if (v == Long.MIN_VALUE) {
            return 20;
        }
        boolean negative = false;
        if (v < 0L) {
            v = -v;
            negative = true;
        }
        int width = v < 100000000L ? (v < 10000L ? (v < 100L ? (v < 10L ? 1 : 2) : (v < 1000L ? 3 : 4)) : (v < 1000000L ? (v < 100000L ? 5 : 6) : (v < 10000000L ? 7 : 8))) : (v < 1000000000000L ? (v < 10000000000L ? (v < 1000000000L ? 9 : 10) : (v < 100000000000L ? 11 : 12)) : (v < 1000000000000000L ? (v < 10000000000000L ? 13 : (v < 100000000000000L ? 14 : 15)) : (v < 100000000000000000L ? (v < 10000000000000000L ? 16 : 17) : (v < 1000000000000000000L ? 18 : 19))));
        return negative ? width + 1 : width;
    }

    public Buffer writeAscii(long v) {
        if (v == 0L) {
            return this.writeByte(48);
        }
        if (v == Long.MIN_VALUE) {
            return this.writeAscii("-9223372036854775808");
        }
        int width = Buffer.asciiSizeInBytes(v);
        int pos = this.pos += width;
        boolean negative = false;
        if (v < 0L) {
            negative = true;
            v = -v;
        }
        while (v != 0L) {
            int digit = (int)(v % 10L);
            this.buf[--pos] = DIGITS[digit];
            v /= 10L;
        }
        if (negative) {
            this.buf[--pos] = 45;
        }
        return this;
    }

    public static int varintSizeInBytes(int value) {
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((value & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    void writeVarint(int v) {
        while ((v & 0xFFFFFF80) != 0) {
            this.buf[this.pos++] = (byte)(v & 0x7F | 0x80);
            v >>>= 7;
        }
        this.buf[this.pos++] = (byte)v;
    }

    public static int varintSizeInBytes(long v) {
        if ((v & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((v & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((v & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((v & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((v & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((v & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((v & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((v & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((v & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    void writeVarint(long v) {
        while ((v & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.buf[this.pos++] = (byte)(v & 0x7FL | 0x80L);
            v >>>= 7;
        }
        this.buf[this.pos++] = (byte)v;
    }

    void writeLongLe(long v) {
        this.buf[this.pos++] = (byte)(v & 0xFFL);
        this.buf[this.pos++] = (byte)(v >> 8 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >> 16 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >> 24 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >> 32 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >> 40 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >> 48 & 0xFFL);
        this.buf[this.pos++] = (byte)(v >> 56 & 0xFFL);
    }

    long readLongLe() {
        return (long)this.buf[this.pos++] & 0xFFL | ((long)this.buf[this.pos++] & 0xFFL) << 8 | ((long)this.buf[this.pos++] & 0xFFL) << 16 | ((long)this.buf[this.pos++] & 0xFFL) << 24 | ((long)this.buf[this.pos++] & 0xFFL) << 32 | ((long)this.buf[this.pos++] & 0xFFL) << 40 | ((long)this.buf[this.pos++] & 0xFFL) << 48 | ((long)this.buf[this.pos++] & 0xFFL) << 56;
    }

    byte readByte() {
        return this.buf[this.pos++];
    }

    int readVarint32() {
        int lastIndex = this.buf.length - 1;
        Buffer.checkNotTruncated(this.pos, lastIndex);
        byte b = this.buf[this.pos++];
        if (b >= 0) {
            return b;
        }
        int result = b & 0x7F;
        Buffer.checkNotTruncated(this.pos, lastIndex);
        b = this.buf[this.pos++];
        if (b >= 0) {
            return result | b << 7;
        }
        result |= (b & 0x7F) << 7;
        Buffer.checkNotTruncated(this.pos, lastIndex);
        b = this.buf[this.pos++];
        if (b >= 0) {
            return result | b << 14;
        }
        result |= (b & 0x7F) << 14;
        Buffer.checkNotTruncated(this.pos, lastIndex);
        b = this.buf[this.pos++];
        if (b >= 0) {
            return result | b << 21;
        }
        result |= (b & 0x7F) << 21;
        Buffer.checkNotTruncated(this.pos, lastIndex);
        b = this.buf[this.pos];
        if ((b & 0xF0) != 0) {
            throw new IllegalArgumentException("Greater than 32-bit varint at position " + this.pos);
        }
        return result | b << 28;
    }

    static void checkNotTruncated(int pos, int lastIndex) {
        if (pos > lastIndex) {
            throw new IllegalArgumentException("Truncated reading position " + pos);
        }
    }

    long readVarint64() {
        int lastIndex = this.buf.length - 1;
        Buffer.checkNotTruncated(this.pos, lastIndex);
        byte b = this.buf[this.pos++];
        if (b >= 0) {
            return b;
        }
        long result = b & 0x7F;
        for (int i = 1; b < 0 && i < 10; ++i) {
            Buffer.checkNotTruncated(this.pos, lastIndex);
            b = this.buf[this.pos++];
            if (i == 9 && (b & 0xF0) != 0) {
                throw new IllegalArgumentException("Greater than 64-bit varint at position " + (this.pos - 1));
            }
            result |= (long)(b & 0x7F) << i * 7;
        }
        return result;
    }

    int remaining() {
        return this.buf.length - this.pos;
    }

    boolean skip(int maxCount) {
        int nextPos = this.pos + maxCount;
        if (nextPos > this.buf.length) {
            this.pos = this.buf.length;
            return false;
        }
        this.pos = nextPos;
        return true;
    }

    public byte[] toByteArray() {
        return this.buf;
    }

    public static interface Writer<T> {
        public int sizeInBytes(T var1);

        public void write(T var1, Buffer var2);
    }
}

