/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import zipkin2.Span;
import zipkin2.internal.Buffer;
import zipkin2.internal.Nullable;
import zipkin2.internal.Proto3SpanWriter;
import zipkin2.internal.Proto3ZipkinFields;

public final class Proto3Codec {
    final Proto3SpanWriter writer = new Proto3SpanWriter();

    public int sizeInBytes(Span input) {
        return this.writer.sizeInBytes(input);
    }

    public byte[] write(Span span) {
        return this.writer.write(span);
    }

    public byte[] writeList(List<Span> spans) {
        return this.writer.writeList(spans);
    }

    public int writeList(List<Span> spans, byte[] out, int pos) {
        return this.writer.writeList(spans, out, pos);
    }

    public static boolean read(byte[] bytes, Collection<Span> out) {
        if (bytes.length == 0) {
            return false;
        }
        Buffer buffer = new Buffer(bytes, 0);
        try {
            Span span = Proto3ZipkinFields.SPAN.read(buffer);
            if (span == null) {
                return false;
            }
            out.add(span);
            return true;
        }
        catch (Exception e) {
            throw Proto3Codec.exceptionReading("Span", e);
        }
    }

    @Nullable
    public static Span readOne(byte[] bytes) {
        return Proto3ZipkinFields.SPAN.read(new Buffer(bytes, 0));
    }

    public static boolean readList(byte[] bytes, Collection<Span> out) {
        int length = bytes.length;
        if (length == 0) {
            return false;
        }
        Buffer buffer = new Buffer(bytes, 0);
        try {
            while (buffer.pos < length) {
                Span span = Proto3ZipkinFields.SPAN.read(buffer);
                if (span == null) {
                    return false;
                }
                out.add(span);
            }
        }
        catch (Exception e) {
            throw Proto3Codec.exceptionReading("List<Span>", e);
        }
        return true;
    }

    public static List<Span> readList(byte[] bytes) {
        ArrayList<Span> out = new ArrayList<Span>();
        if (!Proto3Codec.readList(bytes, out)) {
            return Collections.emptyList();
        }
        return out;
    }

    static IllegalArgumentException exceptionReading(String type, Exception e) {
        String cause;
        String string = cause = e.getMessage() == null ? "Error" : e.getMessage();
        if (cause.indexOf("Malformed") != -1) {
            cause = "Malformed";
        }
        String message = String.format("%s reading %s from proto3", cause, type);
        throw new IllegalArgumentException(message, e);
    }
}

