package eleme.openapi.sdk.api.entity.invoice;

import eleme.openapi.sdk.api.entity.invoice.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class NaposInvoiceInfoV2{

    /**
     * 开具类型
     */
    private String IssueType;
    public String getIssueType() {
        return IssueType;
    }
    public void setIssueType(String IssueType) {
        this.IssueType = IssueType;
    }
    
    /**
     * 发票类型
     */
    private String invoiceType;
    public String getInvoiceType() {
        return invoiceType;
    }
    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }
    
    /**
     * 发票代码
     */
    private String invoiceCode;
    public String getInvoiceCode() {
        return invoiceCode;
    }
    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }
    
    /**
     * 发票号码
     */
    private String invoiceNo;
    public String getInvoiceNo() {
        return invoiceNo;
    }
    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }
    
    /**
     * 开票日期
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date invoiceDate;
    public Date getInvoiceDate() {
        return invoiceDate;
    }
    public void setInvoiceDate(Date invoiceDate) {
        this.invoiceDate = invoiceDate;
    }
    
    /**
     * 校验码
     */
    private String validationCode;
    public String getValidationCode() {
        return validationCode;
    }
    public void setValidationCode(String validationCode) {
        this.validationCode = validationCode;
    }
    
    /**
     * 机器编号
     */
    private String machineCode;
    public String getMachineCode() {
        return machineCode;
    }
    public void setMachineCode(String machineCode) {
        this.machineCode = machineCode;
    }
    
    /**
     * 用户抬头
     */
    private NaposUserTitle buyerTitle;
    public NaposUserTitle getBuyerTitle() {
        return buyerTitle;
    }
    public void setBuyerTitle(NaposUserTitle buyerTitle) {
        this.buyerTitle = buyerTitle;
    }
    
    /**
     * 销方信息
     */
    private NaposSellerInfo sellerInfo;
    public NaposSellerInfo getSellerInfo() {
        return sellerInfo;
    }
    public void setSellerInfo(NaposSellerInfo sellerInfo) {
        this.sellerInfo = sellerInfo;
    }
    
    /**
     * 开票总金额（含税总金额）
     */
    private BigDecimal amountWithTax;
    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }
    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }
    
    /**
     * 不含税总金额
     */
    private BigDecimal amountWithoutTax;
    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }
    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }
    
    /**
     * 总税额
     */
    private BigDecimal taxAmount;
    public BigDecimal getTaxAmount() {
        return taxAmount;
    }
    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }
    
    /**
     * 发票备注
     */
    private String memo;
    public String getMemo() {
        return memo;
    }
    public void setMemo(String memo) {
        this.memo = memo;
    }
    
    /**
     * 发票文件列表
     */
    private List<NaposInvoiceFileInfo> fileInfoList;
    public List<NaposInvoiceFileInfo> getFileInfoList() {
        return fileInfoList;
    }
    public void setFileInfoList(List<NaposInvoiceFileInfo> fileInfoList) {
        this.fileInfoList = fileInfoList;
    }
    
    /**
     * 发票行列表
     */
    private List<NaposInvoiceLineInfo> lineList;
    public List<NaposInvoiceLineInfo> getLineList() {
        return lineList;
    }
    public void setLineList(List<NaposInvoiceLineInfo> lineList) {
        this.lineList = lineList;
    }
    
}