package eleme.openapi.sdk.api.entity.order;

import eleme.openapi.sdk.api.enumeration.order.*;
import eleme.openapi.sdk.api.entity.order.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class OOrder{

    /**
     * 顾客送餐地址
     */
    private String address;
    public String getAddress() {
        return address;
    }
    public void setAddress(String address) {
        this.address = address;
    }
    
    /**
     * 下单时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date createdAt;
    public Date getCreatedAt() {
        return createdAt;
    }
    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }
    
    /**
     * 订单生效时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date activeAt;
    public Date getActiveAt() {
        return activeAt;
    }
    public void setActiveAt(Date activeAt) {
        this.activeAt = activeAt;
    }
    
    /**
     * 用户实际支付配送费
     */
    private double deliverFee;
    public double getDeliverFee() {
        return deliverFee;
    }
    public void setDeliverFee(double deliverFee) {
        this.deliverFee = deliverFee;
    }
    
    /**
     * 商家替用户承担的配送费
     */
    private double merchantDeliverySubsidy;
    public double getMerchantDeliverySubsidy() {
        return merchantDeliverySubsidy;
    }
    public void setMerchantDeliverySubsidy(double merchantDeliverySubsidy) {
        this.merchantDeliverySubsidy = merchantDeliverySubsidy;
    }
    
    /**
     * 会员减配送费
     */
    private double vipDeliveryFeeDiscount;
    public double getVipDeliveryFeeDiscount() {
        return vipDeliveryFeeDiscount;
    }
    public void setVipDeliveryFeeDiscount(double vipDeliveryFeeDiscount) {
        this.vipDeliveryFeeDiscount = vipDeliveryFeeDiscount;
    }
    
    /**
     * 预计送达时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date deliverTime;
    public Date getDeliverTime() {
        return deliverTime;
    }
    public void setDeliverTime(Date deliverTime) {
        this.deliverTime = deliverTime;
    }
    
    /**
     * 即时单的预计时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date instantOrderDeliverTime;
    public Date getInstantOrderDeliverTime() {
        return instantOrderDeliverTime;
    }
    public void setInstantOrderDeliverTime(Date instantOrderDeliverTime) {
        this.instantOrderDeliverTime = instantOrderDeliverTime;
    }
    
    /**
     * 订单备注
     */
    private String description;
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    
    /**
     * 订单详细类目的列表
     */
    private List<OGoodsGroup> groups;
    public List<OGoodsGroup> getGroups() {
        return groups;
    }
    public void setGroups(List<OGoodsGroup> groups) {
        this.groups = groups;
    }
    
    /**
     * 是否口袋订单
     */
    private boolean bagOrder;
    public boolean getBagOrder() {
        return bagOrder;
    }
    public void setBagOrder(boolean bagOrder) {
        this.bagOrder = bagOrder;
    }
    
    /**
     * 发票抬头
     */
    private String invoice;
    public String getInvoice() {
        return invoice;
    }
    public void setInvoice(String invoice) {
        this.invoice = invoice;
    }
    
    /**
     * 用户收取发票的邮箱
     */
    private String invoiceEmail;
    public String getInvoiceEmail() {
        return invoiceEmail;
    }
    public void setInvoiceEmail(String invoiceEmail) {
        this.invoiceEmail = invoiceEmail;
    }
    
    /**
     * 是否预订单
     */
    private boolean book;
    public boolean getBook() {
        return book;
    }
    public void setBook(boolean book) {
        this.book = book;
    }
    
    /**
     * 是否在线支付
     */
    private boolean onlinePaid;
    public boolean getOnlinePaid() {
        return onlinePaid;
    }
    public void setOnlinePaid(boolean onlinePaid) {
        this.onlinePaid = onlinePaid;
    }
    
    /**
     * 订单Id
     */
    private String id;
    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    
    /**
     * 顾客联系电话
     */
    private List<String> phoneList;
    public List<String> getPhoneList() {
        return phoneList;
    }
    public void setPhoneList(List<String> phoneList) {
        this.phoneList = phoneList;
    }
    
    /**
     * 店铺Id
     */
    private long shopId;
    public long getShopId() {
        return shopId;
    }
    public void setShopId(long shopId) {
        this.shopId = shopId;
    }
    
    /**
     * 店铺绑定的外部ID
     */
    private String openId;
    public String getOpenId() {
        return openId;
    }
    public void setOpenId(String openId) {
        this.openId = openId;
    }
    
    /**
     * 店铺名称
     */
    private String shopName;
    public String getShopName() {
        return shopName;
    }
    public void setShopName(String shopName) {
        this.shopName = shopName;
    }
    
    /**
     * 店铺当日订单流水号
     */
    private int daySn;
    public int getDaySn() {
        return daySn;
    }
    public void setDaySn(int daySn) {
        this.daySn = daySn;
    }
    
    /**
     * 订单状态
     */
    private OOrderStatus status;
    public OOrderStatus getStatus() {
        return status;
    }
    public void setStatus(OOrderStatus status) {
        this.status = status;
    }
    
    /**
     * 退单状态
     */
    private OOrderRefundStatus refundStatus;
    public OOrderRefundStatus getRefundStatus() {
        return refundStatus;
    }
    public void setRefundStatus(OOrderRefundStatus refundStatus) {
        this.refundStatus = refundStatus;
    }
    
    /**
     * 下单用户的Id（后续将废弃，使用string类型）
     */
    private long userId;
    public long getUserId() {
        return userId;
    }
    public void setUserId(long userId) {
        this.userId = userId;
    }
    
    /**
     * 下单用户的Id（后续将废弃，使用openUserId）
     */
    private String userIdStr;
    public String getUserIdStr() {
        return userIdStr;
    }
    public void setUserIdStr(String userIdStr) {
        this.userIdStr = userIdStr;
    }
    
    /**
     * 下单用户加密的Id新字段如果加密失败则返回userId和userIdStr
     */
    private String openUserId;
    public String getOpenUserId() {
        return openUserId;
    }
    public void setOpenUserId(String openUserId) {
        this.openUserId = openUserId;
    }
    
    /**
     * 订单总价，用户实际支付的金额，单位：元
     */
    private double totalPrice;
    public double getTotalPrice() {
        return totalPrice;
    }
    public void setTotalPrice(double totalPrice) {
        this.totalPrice = totalPrice;
    }
    
    /**
     * 订单原始价格
     */
    private double originalPrice;
    public double getOriginalPrice() {
        return originalPrice;
    }
    public void setOriginalPrice(double originalPrice) {
        this.originalPrice = originalPrice;
    }
    
    /**
     * 订单收货人姓名
     */
    private String consignee;
    public String getConsignee() {
        return consignee;
    }
    public void setConsignee(String consignee) {
        this.consignee = consignee;
    }
    
    /**
     * 订单收货地址经纬度(高德地图坐标系)
     */
    private String deliveryGeo;
    public String getDeliveryGeo() {
        return deliveryGeo;
    }
    public void setDeliveryGeo(String deliveryGeo) {
        this.deliveryGeo = deliveryGeo;
    }
    
    /**
     * 顾客送餐地址
     */
    private String deliveryPoiAddress;
    public String getDeliveryPoiAddress() {
        return deliveryPoiAddress;
    }
    public void setDeliveryPoiAddress(String deliveryPoiAddress) {
        this.deliveryPoiAddress = deliveryPoiAddress;
    }
    
    /**
     * 顾客是否需要发票
     */
    private boolean invoiced;
    public boolean getInvoiced() {
        return invoiced;
    }
    public void setInvoiced(boolean invoiced) {
        this.invoiced = invoiced;
    }
    
    /**
     * 店铺实收
     */
    private double income;
    public double getIncome() {
        return income;
    }
    public void setIncome(double income) {
        this.income = income;
    }
    
    /**
     * 饿了么服务费率
     */
    private double serviceRate;
    public double getServiceRate() {
        return serviceRate;
    }
    public void setServiceRate(double serviceRate) {
        this.serviceRate = serviceRate;
    }
    
    /**
     * 饿了么抽佣服务费（技术服务费）
     */
    private double serviceFee;
    public double getServiceFee() {
        return serviceFee;
    }
    public void setServiceFee(double serviceFee) {
        this.serviceFee = serviceFee;
    }
    
    /**
     * 用户使用津贴（随单代收，周期返还）
     */
    private double allowanceServiceFee;
    public double getAllowanceServiceFee() {
        return allowanceServiceFee;
    }
    public void setAllowanceServiceFee(double allowanceServiceFee) {
        this.allowanceServiceFee = allowanceServiceFee;
    }
    
    /**
     * 饿了么基础物流费（物流系统费）
     */
    private double baseLogisticsServiceFee;
    public double getBaseLogisticsServiceFee() {
        return baseLogisticsServiceFee;
    }
    public void setBaseLogisticsServiceFee(double baseLogisticsServiceFee) {
        this.baseLogisticsServiceFee = baseLogisticsServiceFee;
    }
    
    /**
     * 时段加价
     */
    private double timeIntervalMarkUpFee;
    public double getTimeIntervalMarkUpFee() {
        return timeIntervalMarkUpFee;
    }
    public void setTimeIntervalMarkUpFee(double timeIntervalMarkUpFee) {
        this.timeIntervalMarkUpFee = timeIntervalMarkUpFee;
    }
    
    /**
     * 距离加价
     */
    private double distanceIncreaseFee;
    public double getDistanceIncreaseFee() {
        return distanceIncreaseFee;
    }
    public void setDistanceIncreaseFee(double distanceIncreaseFee) {
        this.distanceIncreaseFee = distanceIncreaseFee;
    }
    
    /**
     * 订单中红包金额
     */
    private double hongbao;
    public double getHongbao() {
        return hongbao;
    }
    public void setHongbao(double hongbao) {
        this.hongbao = hongbao;
    }
    
    /**
     * 打包费金额
     */
    private double packageFee;
    public double getPackageFee() {
        return packageFee;
    }
    public void setPackageFee(double packageFee) {
        this.packageFee = packageFee;
    }
    
    /**
     * 增值服务费
     */
    private double additionServicePrice;
    public double getAdditionServicePrice() {
        return additionServicePrice;
    }
    public void setAdditionServicePrice(double additionServicePrice) {
        this.additionServicePrice = additionServicePrice;
    }
    
    /**
     * 价格加价
     */
    private double pricePremiums;
    public double getPricePremiums() {
        return pricePremiums;
    }
    public void setPricePremiums(double pricePremiums) {
        this.pricePremiums = pricePremiums;
    }
    
    /**
     * 订单活动总额
     */
    private double activityTotal;
    public double getActivityTotal() {
        return activityTotal;
    }
    public void setActivityTotal(double activityTotal) {
        this.activityTotal = activityTotal;
    }
    
    /**
     * 店铺承担活动费用
     */
    private double shopPart;
    public double getShopPart() {
        return shopPart;
    }
    public void setShopPart(double shopPart) {
        this.shopPart = shopPart;
    }
    
    /**
     * 饿了么承担活动费用
     */
    private double elemePart;
    public double getElemePart() {
        return elemePart;
    }
    public void setElemePart(double elemePart) {
        this.elemePart = elemePart;
    }
    
    /**
     * 降级标识
     */
    private boolean downgraded;
    public boolean getDowngraded() {
        return downgraded;
    }
    public void setDowngraded(boolean downgraded) {
        this.downgraded = downgraded;
    }
    
    /**
     * 保护小号失效时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date secretPhoneExpireTime;
    public Date getSecretPhoneExpireTime() {
        return secretPhoneExpireTime;
    }
    public void setSecretPhoneExpireTime(Date secretPhoneExpireTime) {
        this.secretPhoneExpireTime = secretPhoneExpireTime;
    }
    
    /**
     * 订单参加活动信息
     */
    private List<OActivity> orderActivities;
    public List<OActivity> getOrderActivities() {
        return orderActivities;
    }
    public void setOrderActivities(List<OActivity> orderActivities) {
        this.orderActivities = orderActivities;
    }
    
    /**
     * 发票类型
     */
    private InvoiceType invoiceType;
    public InvoiceType getInvoiceType() {
        return invoiceType;
    }
    public void setInvoiceType(InvoiceType invoiceType) {
        this.invoiceType = invoiceType;
    }
    
    /**
     * 纳税人识别号
     */
    private String taxpayerId;
    public String getTaxpayerId() {
        return taxpayerId;
    }
    public void setTaxpayerId(String taxpayerId) {
        this.taxpayerId = taxpayerId;
    }
    
    /**
     * 冷链加价费
     */
    private double coldBoxFee;
    public double getColdBoxFee() {
        return coldBoxFee;
    }
    public void setColdBoxFee(double coldBoxFee) {
        this.coldBoxFee = coldBoxFee;
    }
    
    /**
     * 用户取消原因
     */
    private String cancelOrderDescription;
    public String getCancelOrderDescription() {
        return cancelOrderDescription;
    }
    public void setCancelOrderDescription(String cancelOrderDescription) {
        this.cancelOrderDescription = cancelOrderDescription;
    }
    
    /**
     * 用户申请取消时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date cancelOrderCreatedAt;
    public Date getCancelOrderCreatedAt() {
        return cancelOrderCreatedAt;
    }
    public void setCancelOrderCreatedAt(Date cancelOrderCreatedAt) {
        this.cancelOrderCreatedAt = cancelOrderCreatedAt;
    }
    
    /**
     * 抽佣
     */
    private List<OCommission> orderCommissions;
    public List<OCommission> getOrderCommissions() {
        return orderCommissions;
    }
    public void setOrderCommissions(List<OCommission> orderCommissions) {
        this.orderCommissions = orderCommissions;
    }
    
    /**
     * 是否饿了么星选来源
     */
    private boolean baiduWaimai;
    public boolean getBaiduWaimai() {
        return baiduWaimai;
    }
    public void setBaiduWaimai(boolean baiduWaimai) {
        this.baiduWaimai = baiduWaimai;
    }
    
    /**
     * 顾客联系电话
     */
    private List<String> consigneePhones;
    public List<String> getConsigneePhones() {
        return consigneePhones;
    }
    public void setConsigneePhones(List<String> consigneePhones) {
        this.consigneePhones = consigneePhones;
    }
    
    /**
     * 订单商品额外信息
     */
    private UserExtraInfo userExtraInfo;
    public UserExtraInfo getUserExtraInfo() {
        return userExtraInfo;
    }
    public void setUserExtraInfo(UserExtraInfo userExtraInfo) {
        this.userExtraInfo = userExtraInfo;
    }
    
    /**
     * 超级会员标识
     */
    private SuperVip superVip;
    public SuperVip getSuperVip() {
        return superVip;
    }
    public void setSuperVip(SuperVip superVip) {
        this.superVip = superVip;
    }
    
    /**
     * 商家确认出餐时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date confirmCookingTime;
    public Date getConfirmCookingTime() {
        return confirmCookingTime;
    }
    public void setConfirmCookingTime(Date confirmCookingTime) {
        this.confirmCookingTime = confirmCookingTime;
    }
    
    /**
     * 订单业务类型
     */
    private int orderBusinessType;
    public int getOrderBusinessType() {
        return orderBusinessType;
    }
    public void setOrderBusinessType(int orderBusinessType) {
        this.orderBusinessType = orderBusinessType;
    }
    
    /**
     * 到店自取时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date pickUpTime;
    public Date getPickUpTime() {
        return pickUpTime;
    }
    public void setPickUpTime(Date pickUpTime) {
        this.pickUpTime = pickUpTime;
    }
    
    /**
     * 取货码(用户的取餐凭证,为饿了么订单流水号)
     */
    private int pickUpNumber;
    public int getPickUpNumber() {
        return pickUpNumber;
    }
    public void setPickUpNumber(int pickUpNumber) {
        this.pickUpNumber = pickUpNumber;
    }
    
    /**
     * 用户承担部分（特殊合作商户专用）
     */
    private double specUserPart;
    public double getSpecUserPart() {
        return specUserPart;
    }
    public void setSpecUserPart(double specUserPart) {
        this.specUserPart = specUserPart;
    }
    
    /**
     * 是否是企业订餐订单
     */
    private Boolean isBusinessOrder;
    public Boolean getIsBusinessOrder() {
        return isBusinessOrder;
    }
    public void setIsBusinessOrder(Boolean isBusinessOrder) {
        this.isBusinessOrder = isBusinessOrder;
    }
    
    /**
     * 是否是拼团订单
     */
    private Boolean pinTuanOrder;
    public Boolean getPinTuanOrder() {
        return pinTuanOrder;
    }
    public void setPinTuanOrder(Boolean pinTuanOrder) {
        this.pinTuanOrder = pinTuanOrder;
    }
    
    /**
     * 扩展信息
     */
    private String extraJson;
    public String getExtraJson() {
        return extraJson;
    }
    public void setExtraJson(String extraJson) {
        this.extraJson = extraJson;
    }
    
    /**
     * 订单来源标签
     */
    private OrderSourceTag orderSourceTag;
    public OrderSourceTag getOrderSourceTag() {
        return orderSourceTag;
    }
    public void setOrderSourceTag(OrderSourceTag orderSourceTag) {
        this.orderSourceTag = orderSourceTag;
    }
    
    /**
     * 配送费优惠
     */
    private OActivity logisticsActivity;
    public OActivity getLogisticsActivity() {
        return logisticsActivity;
    }
    public void setLogisticsActivity(OActivity logisticsActivity) {
        this.logisticsActivity = logisticsActivity;
    }
    
    /**
     * 增值服务费（店铺推广）
     */
    private double cpcAmount;
    public double getCpcAmount() {
        return cpcAmount;
    }
    public void setCpcAmount(double cpcAmount) {
        this.cpcAmount = cpcAmount;
    }
    
    /**
     * 商户公益捐赠金额(以元为单位)
     */
    private double contributionAmount;
    public double getContributionAmount() {
        return contributionAmount;
    }
    public void setContributionAmount(double contributionAmount) {
        this.contributionAmount = contributionAmount;
    }
    
    /**
     * 预计配送时间 是否展示时间片信息
     */
    private Boolean timeSlice;
    public Boolean getTimeSlice() {
        return timeSlice;
    }
    public void setTimeSlice(Boolean timeSlice) {
        this.timeSlice = timeSlice;
    }
    
    /**
     * 时间片开始时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date timeSliceStart;
    public Date getTimeSliceStart() {
        return timeSliceStart;
    }
    public void setTimeSliceStart(Date timeSliceStart) {
        this.timeSliceStart = timeSliceStart;
    }
    
    /**
     * 时间片结束时间
     */
    @JsonFormat(locale = "zh" , timezone="GMT+8")
    private Date timeSliceEnd;
    public Date getTimeSliceEnd() {
        return timeSliceEnd;
    }
    public void setTimeSliceEnd(Date timeSliceEnd) {
        this.timeSliceEnd = timeSliceEnd;
    }
    
    /**
     * 物流标品id
     */
    private Integer deliveryProductId;
    public Integer getDeliveryProductId() {
        return deliveryProductId;
    }
    public void setDeliveryProductId(Integer deliveryProductId) {
        this.deliveryProductId = deliveryProductId;
    }
    
    /**
     * 品牌会员信息
     */
    private BrandMemberInfo brandMemberInfo;
    public BrandMemberInfo getBrandMemberInfo() {
        return brandMemberInfo;
    }
    public void setBrandMemberInfo(BrandMemberInfo brandMemberInfo) {
        this.brandMemberInfo = brandMemberInfo;
    }
    
    /**
     * 是否使用x+y服务包的标识
     */
    private Boolean xyPackFlag;
    public Boolean getXyPackFlag() {
        return xyPackFlag;
    }
    public void setXyPackFlag(Boolean xyPackFlag) {
        this.xyPackFlag = xyPackFlag;
    }
    
    /**
     * 履约服务费
     */
    private double fulfillServiceFee;
    public double getFulfillServiceFee() {
        return fulfillServiceFee;
    }
    public void setFulfillServiceFee(double fulfillServiceFee) {
        this.fulfillServiceFee = fulfillServiceFee;
    }
    
    /**
     * 总合计金额
     */
    private double totalAmount;
    public double getTotalAmount() {
        return totalAmount;
    }
    public void setTotalAmount(double totalAmount) {
        this.totalAmount = totalAmount;
    }
    
    /**
     * 总优惠金额
     */
    private double totalActivityAmount;
    public double getTotalActivityAmount() {
        return totalActivityAmount;
    }
    public void setTotalActivityAmount(double totalActivityAmount) {
        this.totalActivityAmount = totalActivityAmount;
    }
    
    /**
     * 配送费原价 + 打包费金额
     */
    private double deliveryPackageFee;
    public double getDeliveryPackageFee() {
        return deliveryPackageFee;
    }
    public void setDeliveryPackageFee(double deliveryPackageFee) {
        this.deliveryPackageFee = deliveryPackageFee;
    }
    
    /**
     * 城市名称
     */
    private String cityName;
    public String getCityName() {
        return cityName;
    }
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }
    
    /**
     * 爱心商家捐赠金额
     */
    private double publicWelfareGoodsFee;
    public double getPublicWelfareGoodsFee() {
        return publicWelfareGoodsFee;
    }
    public void setPublicWelfareGoodsFee(double publicWelfareGoodsFee) {
        this.publicWelfareGoodsFee = publicWelfareGoodsFee;
    }
    
    /**
     * 商户和收货人之间的距离,单位米
     */
    private String distanceBetweenMerchantsAndConsignee;
    public String getDistanceBetweenMerchantsAndConsignee() {
        return distanceBetweenMerchantsAndConsignee;
    }
    public void setDistanceBetweenMerchantsAndConsignee(String distanceBetweenMerchantsAndConsignee) {
        this.distanceBetweenMerchantsAndConsignee = distanceBetweenMerchantsAndConsignee;
    }
    
    /**
     * 订单活动金额承担划分
     */
    private List<OOrderActivityPart> orderActivityParts;
    public List<OOrderActivityPart> getOrderActivityParts() {
        return orderActivityParts;
    }
    public void setOrderActivityParts(List<OOrderActivityPart> orderActivityParts) {
        this.orderActivityParts = orderActivityParts;
    }
    
    /**
     * 饿了么订单id(保持兼容)
     */
    private String orderId;
    public String getOrderId() {
        return orderId;
    }
    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }
    
    /**
     * 用户承担部分
     */
    private double userPart;
    public double getUserPart() {
        return userPart;
    }
    public void setUserPart(double userPart) {
        this.userPart = userPart;
    }
    
    /**
     * 商流标品id
     */
    private Long spuId;
    public Long getSpuId() {
        return spuId;
    }
    public void setSpuId(Long spuId) {
        this.spuId = spuId;
    }
    
    /**
     * 商流服务商品
     */
    private Long skuId;
    public Long getSkuId() {
        return skuId;
    }
    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }
    
    /**
     * 是否是拼团订单
     */
    private Boolean ptOrder;
    public Boolean getPtOrder() {
        return ptOrder;
    }
    public void setPtOrder(Boolean ptOrder) {
        this.ptOrder = ptOrder;
    }
    
    /**
     * 履约作业模式
     */
    private String merchantFulfillJobMode;
    public String getMerchantFulfillJobMode() {
        return merchantFulfillJobMode;
    }
    public void setMerchantFulfillJobMode(String merchantFulfillJobMode) {
        this.merchantFulfillJobMode = merchantFulfillJobMode;
    }
    
    /**
     * 饿了么拼团订单拓展信息
     */
    private PtOrderExtraData ptOrderExtraData;
    public PtOrderExtraData getPtOrderExtraData() {
        return ptOrderExtraData;
    }
    public void setPtOrderExtraData(PtOrderExtraData ptOrderExtraData) {
        this.ptOrderExtraData = ptOrderExtraData;
    }
    
    /**
     * 打包费模块
     */
    private PackageFeeInfo packageFeeInfo;
    public PackageFeeInfo getPackageFeeInfo() {
        return packageFeeInfo;
    }
    public void setPackageFeeInfo(PackageFeeInfo packageFeeInfo) {
        this.packageFeeInfo = packageFeeInfo;
    }
    
}