package eleme.openapi.sdk.api.entity.product;

import eleme.openapi.sdk.api.enumeration.product.*;
import eleme.openapi.sdk.api.entity.product.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class OSpuIngredientSpec{

    /**
     * 配料SPU的规格Id
     */
    private Long spuSpecId;
    public Long getSpuSpecId() {
        return spuSpecId;
    }
    public void setSpuSpecId(Long spuSpecId) {
        this.spuSpecId = spuSpecId;
    }
    
    /**
     * 配料SPU规格外部编码
     */
    private String spuSpecOutCode;
    public String getSpuSpecOutCode() {
        return spuSpecOutCode;
    }
    public void setSpuSpecOutCode(String spuSpecOutCode) {
        this.spuSpecOutCode = spuSpecOutCode;
    }
    
    /**
     * 是否必选
     */
    private Boolean required;
    public Boolean getRequired() {
        return required;
    }
    public void setRequired(Boolean required) {
        this.required = required;
    }
    
    /**
     * 是否选中状态
     */
    private boolean selected;
    public boolean getSelected() {
        return selected;
    }
    public void setSelected(boolean selected) {
        this.selected = selected;
    }
    
    /**
     * 售卖状态
     */
    private Integer saleStatus;
    public Integer getSaleStatus() {
        return saleStatus;
    }
    public void setSaleStatus(Integer saleStatus) {
        this.saleStatus = saleStatus;
    }
    
    /**
     * 配料默认选中个数，不填C端默认为1
     */
    private Integer defaultSelectNum;
    public Integer getDefaultSelectNum() {
        return defaultSelectNum;
    }
    public void setDefaultSelectNum(Integer defaultSelectNum) {
        this.defaultSelectNum = defaultSelectNum;
    }
    
    /**
     * 配料最少选则个数，不填不限制
     */
    private Integer minSelectNum;
    public Integer getMinSelectNum() {
        return minSelectNum;
    }
    public void setMinSelectNum(Integer minSelectNum) {
        this.minSelectNum = minSelectNum;
    }
    
    /**
     * 配料最多选择个数，不填C端默认为1，[1, 20]
     */
    private Integer maxSelectNum;
    public Integer getMaxSelectNum() {
        return maxSelectNum;
    }
    public void setMaxSelectNum(Integer maxSelectNum) {
        this.maxSelectNum = maxSelectNum;
    }
    
    /**
     * 自定义定价
     */
    private OPriceInfo customPriceInfo;
    public OPriceInfo getCustomPriceInfo() {
        return customPriceInfo;
    }
    public void setCustomPriceInfo(OPriceInfo customPriceInfo) {
        this.customPriceInfo = customPriceInfo;
    }
    
    /**
     * 份数
     */
    private Integer quantity;
    public Integer getQuantity() {
        return quantity;
    }
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
    
}