package eleme.openapi.sdk.api.entity.product;

import eleme.openapi.sdk.api.enumeration.product.*;
import eleme.openapi.sdk.api.entity.product.*;
import java.util.*;
import java.math.BigDecimal;
import com.fasterxml.jackson.annotation.JsonFormat;

public class OSpuSpec{

    /**
     * 规格Id
     */
    private Long specId;
    public Long getSpecId() {
        return specId;
    }
    public void setSpecId(Long specId) {
        this.specId = specId;
    }
    
    /**
     * 名称
     */
    private String name;
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    
    /**
     * 商品价格
     */
    private double price;
    public double getPrice() {
        return price;
    }
    public void setPrice(double price) {
        this.price = price;
    }
    
    /**
     * 价格类型
     */
    private String priceType;
    public String getPriceType() {
        return priceType;
    }
    public void setPriceType(String priceType) {
        this.priceType = priceType;
    }
    
    /**
     * 套餐类型
     */
    private String packageType;
    public String getPackageType() {
        return packageType;
    }
    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }
    
    /**
     * 图片信息
     */
    private List<OImage> images;
    public List<OImage> getImages() {
        return images;
    }
    public void setImages(List<OImage> images) {
        this.images = images;
    }
    
    /**
     * 库存量
     */
    private int stock;
    public int getStock() {
        return stock;
    }
    public void setStock(int stock) {
        this.stock = stock;
    }
    
    /**
     * 最大库存量
     */
    private int maxStock;
    public int getMaxStock() {
        return maxStock;
    }
    public void setMaxStock(int maxStock) {
        this.maxStock = maxStock;
    }
    
    /**
     * 是否次日自动置满库存
     */
    private Integer stockStatus;
    public Integer getStockStatus() {
        return stockStatus;
    }
    public void setStockStatus(Integer stockStatus) {
        this.stockStatus = stockStatus;
    }
    
    /**
     * 打包费
     */
    private double packingFee;
    public double getPackingFee() {
        return packingFee;
    }
    public void setPackingFee(double packingFee) {
        this.packingFee = packingFee;
    }
    
    /**
     * 商品扩展码
     */
    private String specOutCode;
    public String getSpecOutCode() {
        return specOutCode;
    }
    public void setSpecOutCode(String specOutCode) {
        this.specOutCode = specOutCode;
    }
    
    /**
     * 当该规格是CSPU规格时，对应SPU specOutCode
     */
    private String parentSpecOutCode;
    public String getParentSpecOutCode() {
        return parentSpecOutCode;
    }
    public void setParentSpecOutCode(String parentSpecOutCode) {
        this.parentSpecOutCode = parentSpecOutCode;
    }
    
    /**
     * 商品条形码
     */
    private String barCode;
    public String getBarCode() {
        return barCode;
    }
    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }
    
    /**
     * 规格卡路里
     */
    private Long calorie;
    public Long getCalorie() {
        return calorie;
    }
    public void setCalorie(Long calorie) {
        this.calorie = calorie;
    }
    
    /**
     * 份量值
     */
    private Integer quantity;
    public Integer getQuantity() {
        return quantity;
    }
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }
    
    /**
     * 份量单位
     */
    private String unit;
    public String getUnit() {
        return unit;
    }
    public void setUnit(String unit) {
        this.unit = unit;
    }
    
    /**
     * 包装盒份数
     */
    private Integer packageShare;
    public Integer getPackageShare() {
        return packageShare;
    }
    public void setPackageShare(Integer packageShare) {
        this.packageShare = packageShare;
    }
    
    /**
     * 商品规格
     */
    private List<OSpecValue> specValues;
    public List<OSpecValue> getSpecValues() {
        return specValues;
    }
    public void setSpecValues(List<OSpecValue> specValues) {
        this.specValues = specValues;
    }
    
    /**
     * 配料分组
     */
    private List<OSpuIngredientGroup> ingredientGroups;
    public List<OSpuIngredientGroup> getIngredientGroups() {
        return ingredientGroups;
    }
    public void setIngredientGroups(List<OSpuIngredientGroup> ingredientGroups) {
        this.ingredientGroups = ingredientGroups;
    }
    
    /**
     * 配方规则
     */
    private OSpuIngredientRule ingredientRule;
    public OSpuIngredientRule getIngredientRule() {
        return ingredientRule;
    }
    public void setIngredientRule(OSpuIngredientRule ingredientRule) {
        this.ingredientRule = ingredientRule;
    }
    
    /**
     * 属性
     */
    private List<OSpuAttribute> attributes;
    public List<OSpuAttribute> getAttributes() {
        return attributes;
    }
    public void setAttributes(List<OSpuAttribute> attributes) {
        this.attributes = attributes;
    }
    
    /**
     * 互斥spuSpecsCutCode,为单向互斥
     */
    private List<String> mutexSpuSpecOutCodes;
    public List<String> getMutexSpuSpecOutCodes() {
        return mutexSpuSpecOutCodes;
    }
    public void setMutexSpuSpecOutCodes(List<String> mutexSpuSpecOutCodes) {
        this.mutexSpuSpecOutCodes = mutexSpuSpecOutCodes;
    }
    
}