package eleme.openapi.sdk.api.enumeration.order;

public enum EvaluationTag {
    /**
     * 取餐时间太长
     */
    TAKE_MEAL_LONG_TIME("TAKE_MEAL_LONG_TIME"), 
    
    /**
     * 送餐太慢
     */
    FOOD_DELIVERY_SLOW("FOOD_DELIVERY_SLOW"), 
    
    /**
     * 打电话不接
     */
    NO_ONE_RESPONSE_PHONE("NO_ONE_RESPONSE_PHONE"), 
    
    /**
     * 服务态度差
     */
    SERVICE_BAD("SERVICE_BAD"), 
    
    /**
     * 用户未收到餐
     */
    USER_NOT_RECEIVE_FOOD("USER_NOT_RECEIVE_FOOD"), 
    
    /**
     * 提前点击确认送达
     */
    CONFIRM_ARRIVE_ADVANCE("CONFIRM_ARRIVE_ADVANCE"), 
    
    /**
     * 餐品缺失或洒汤
     */
    LACK_OF_FOOD("LACK_OF_FOOD"), 
    
    /**
     * 诱导用户退单
     */
    INDUCE_USER_REFUND("INDUCE_USER_REFUND"), 
    
    /**
     * 未穿制服
     */
    NOT_WEAR_UNIFORM("NOT_WEAR_UNIFORM"), 
    
    /**
     * 形象邋遢不整洁
     */
    IMAGE_UNTIDY("IMAGE_UNTIDY"), 
    
    /**
     * 取餐准时
     */
    TAKE_MEAL_ON_SCHEDULE("TAKE_MEAL_ON_SCHEDULE"), 
    
    /**
     * 送餐快
     */
    FOOD_DELIVERY_FAST("FOOD_DELIVERY_FAST"), 
    
    /**
     * 服务态度好
     */
    SERVICE_GOOD("SERVICE_GOOD"), 
    
    /**
     * 颜值爆表
     */
    IMAGE_PRETTY("IMAGE_PRETTY"), 
    
    /**
     * 制服整洁
     */
    CLEAR_UNIFORM("CLEAR_UNIFORM"), 
    
    /**
     * 提供额外帮助
     */
    EXTRA_HELP("EXTRA_HELP");
    

    private String orderDesc;
    EvaluationTag(String orderDesc) {
        this.orderDesc = orderDesc;
    }
}