package eleme.openapi.sdk.api.enumeration.order;

public enum ShippingState {
    /**
     * 生成运单
     */
    create("create"), 
    
    /**
     * 配送商接单
     */
    accept("accept"), 
    
    /**
     * 分配配送员
     */
    assign("assign"), 
    
    /**
     * 配送员到店
     */
    arrival("arrival"), 
    
    /**
     * 配送员取餐
     */
    fetch("fetch"), 
    
    /**
     * 配送成功
     */
    complete("complete"), 
    
    /**
     * 配送取消
     */
    cancel("cancel"), 
    
    /**
     * 配送异常
     */
    exception("exception"), 
    
    /**
     * 配送失败
     */
    fail("fail");
    

    private String orderDesc;
    ShippingState(String orderDesc) {
        this.orderDesc = orderDesc;
    }
}