package eleme.openapi.sdk.api.enumeration.recruitment;

public enum CurrentStatusEnum {
    /**
     * 我目前已离职
     */
    OFF_WORK("OFF_WORK"), 
    
    /**
     * 可快速到岗
     */
    ARRIVE_SOON("ARRIVE_SOON"), 
    
    /**
     * 我目前在职
     */
    ON_WORK("ON_WORK"), 
    
    /**
     * 正考虑换个新环境
     */
    CONSIDER_CHANGE("CONSIDER_CHANGE"), 
    
    /**
     * 我暂时不想找工作
     */
    NO_INTEREST("NO_INTEREST"), 
    
    /**
     * 我是应届毕业生
     */
    GRADUATE("GRADUATE");
    

    private String recruitmentDesc;
    CurrentStatusEnum(String recruitmentDesc) {
        this.recruitmentDesc = recruitmentDesc;
    }
}