package eleme.openapi.sdk.api.enumeration.shop;

public enum CateringServicesLicenseType {
    /**
     * 餐饮服务许可证
     */
    NORMAL("NORMAL"), 
    
    /**
     * 食品经营许可证
     */
    FoodBusinessLicense("FoodBusinessLicense"), 
    
    /**
     * 食品流通许可证
     */
    FoodDistributionLicense("FoodDistributionLicense"), 
    
    /**
     * 食品摊贩临时经营公示卡
     */
    TemporaryFoodBusinessLicense("TemporaryFoodBusinessLicense"), 
    
    /**
     * 全国工业产品生产许可证
     */
    NationalIndustrialProductionPermit("NationalIndustrialProductionPermit"), 
    
    /**
     * 小徽餐饮分级证/登记凭证
     */
    SmallShopGradeCer("SmallShopGradeCer"), 
    
    /**
     * 食品生产加工作坊准许证
     */
    FoodProductionAndProcessingWorkshopPermit("FoodProductionAndProcessingWorkshopPermit"), 
    
    /**
     * 食品小作坊生产许可证
     */
    FoodSmallWorkshopProductionLicense("FoodSmallWorkshopProductionLicense"), 
    
    /**
     * 食品小作坊登记证
     */
    Food_WorkshopsRegistrationCertificate1("Food_WorkshopsRegistrationCertificate1"), 
    
    /**
     * 食品小作坊备案凭证
     */
    FoodWorkshopsRegistrationCertificate2("FoodWorkshopsRegistrationCertificate2"), 
    
    /**
     * 食品生产加工小作坊核准证
     */
    FoodWorkshopsProductionApprovalCertificate("FoodWorkshopsProductionApprovalCertificate"), 
    
    /**
     * 小作坊、小餐饮登记证/小摊点备案（登记）卡
     */
    SmallShopRegistrationCertificate("SmallShopRegistrationCertificate"), 
    
    /**
     * 食品摊贩备案证明
     */
    FoodVendorsRecordEvidence("FoodVendorsRecordEvidence"), 
    
    /**
     * 小作坊卫生许可证
     */
    SmallShopHealthPermits("SmallShopHealthPermits"), 
    
    /**
     * 食品摊贩登记卡
     */
    FoodVendorsRegistrationCard("FoodVendorsRegistrationCard"), 
    
    /**
     * 食品经营实名备案证
     */
    FoodBusinessTrueName("FoodBusinessTrueName"), 
    
    /**
     * 小餐饮经营许可证
     */
    SmallShopBusinessLicense("SmallShopBusinessLicense");
    

    private String shopDesc;
    CateringServicesLicenseType(String shopDesc) {
        this.shopDesc = shopDesc;
    }
}