package eleme.openapi.sdk.api.enumeration.shop.im;

public enum ContentType {
    /**
     * 普通文本
     */
    TEXT(1, "普通文本", null),

    /**
     * 图片
     */
    IMAGE(2, "图片", "[图片]"),

    /**
     * 语音
     */
    AUDIO(3, "语音", "[语音]"),

    /**
     * 视频
     */
    VIDEO(4, "视频", "[视频]"),

    /**
     * 位置
     */
    GEO(5, "位置", "[位置]"),

    /**
     * 消息
     */
    AT(8, "@消息", "[有人@我]"),

    /**
     * 自定义
     */
    CUSTOM(101, "自定义", null);

    private Integer type;

    private String desc;

    private String pushContent;

    ContentType(Integer type, String desc, String pushContent) {
        this.type = type;
        this.desc = desc;
        this.pushContent = pushContent;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public String getPushContent() {
        return pushContent;
    }
}

